{$M 16000,0,300000}
program War2unit;

uses dos,crt,keystuff,ini,mouse;
const
      maxchoix = 13;
      maxunit = 110;
      maxupgrade = 52;
      Maxproj = 50;
      MaxAI = 83;

      NormalSize = 5696;
      ExpSize    = 5950;

      NormalFileSize = 6478;
      ExpFileSize    = 6372;

      TempFile = 'T$E$M$P$.!!0';

     HexList :ARRAY[0..15] OF CHAR ='0123456789ABCDEF';
     YN : Array[0..1]of Char = 'NY';
type


DosFileName = String;
SectionName = Array[1..4] of char;


Tmap_type = record
    header : SectionName;  {TYPE}
    l      : Longint;
    text   : Array[1..8] of char; {WAR2 MAP}
    id     : Array[1..8] of char;
end;

Tmap_version = record
    header : SectionName;  {VER }
    l      : Longint;
    version: Word;  {11h}
end;

Tmap_desc = record
    header : SectionName;  {DESC}
    l      : Longint;
    description: Array[1..32] of char;
end;

Tmap_owner = record
    header : SectionName;  {OWNR}
    l      : Longint;
    slot   : Array[1..8] of byte;
    none   : Array[1..7] of byte; {3h}
    neutral: Byte;  {2h}
end;
Tmap_terrain = record
    header : SectionName;  {ERA }
    l      : Longint;
    terrain: Word;
end;

{V 1.33 }
Tmap_terrainX = record
    header : SectionName;  {ERAX}
    l      : Longint;
    terrain: Word;         {03h for Swamp}
end;
{-------}

Tmap_dim = record
    header : SectionName;  {DIM }
    l      : Longint;
    x      : Word;  {32x32,64x64,96x96,128x128}
    y      : Word;
end;

Tmap_unitdata = record
    header : SectionName;  {UDTA}
    l      : Longint;
    default: word;   {0 = no; 1 = yes}
    Frame  : Array[1..Maxunit] of word;
    Obselete:Array[1..4*127] of word;
    sight  : Array[1..MaxUnit] of longint;  {1..9}
    HP     : Array[1..MaxUnit] of Word; {1..9999 > cannot display}
    Magician:Array[1..MaxUnit] of Byte;   {0 = no; 1 = yes}
    BuildTime:Array[1..MaxUnit] of byte;
    Gold   : Array[1..MaxUnit] of byte;  {cost = this number * 10}
    Wood   : Array[1..MaxUnit] of byte;
    Oil    : Array[1..MaxUnit] of byte;
    UnitSize:Array[1..MaxUnit] of
                Record
                 x,y:Word;
                End;
    BoxSize: Array[1..MaxUnit] of
                Record
                 x,y:Word;
                End;

    Range:   Array[1..MaxUnit] of byte;
    ReactRange:Array[1..MaxUnit] of byte;
    PlayerReact:Array[1..MaxUnit] of byte;
    Armor  : Array[1..MaxUnit] of byte;
    Tag    : Array[1..MaxUnit] of byte;  {0 = no;  1 = yes    building = no}
    Priority:Array[1..MaxUnit] of byte;  {0 = high  255 = low}
    Basic  : Array[1..MaxUnit] of byte;
    Piercing:Array[1..MaxUnit] of byte;
    Up_weap: Array[1..MaxUnit] of byte;  {0 = no;  1 = yes}
    Up_armor:Array[1..MaxUnit] of byte;  {0 = no;  1 = yes}
    Projectile:Array[1..MaxUnit] of byte;
    UnitType:Array[1..MaxUnit] of byte;  {0 = land; 1 = air; 2 = water}
    Decay  : Array[1..MaxUnit] of byte;  {0 = no decay; x = number of 6 sec. }
    AnnoyCPU:Array[1..MaxUnit] of byte;
    Movement:Array[1..58] of byte;  {1 = can move; 2 = peasant; 4 = sapper}
    Kill   : Array[1..MaxUnit] of Word;
    Target : Array[1..MaxUnit] of byte;  {1 = Land; 2 = Sea; 4 = Air}
    Flags  : Array[1..MaxUnit,1..2] of Word;

    TempBuff:Array[1..254] of Byte;
    {Temp buffer for Decompressed maps}
end;

Tmap_upgrade = record
    header : SectionName;  {UGRD}
    l      : Longint;
    Default: Integer;
    Time   : Array[1..MaxUpgrade] of byte;
    Gold   : Array[1..MaxUpgrade] of Word;
    Wood   : Array[1..MaxUpgrade] of Word;
    Oil    : Array[1..MaxUpgrade] of Word;
    Icon   : Array[1..MaxUpgrade] of Word;
    Group  : Array[1..MaxUpgrade] of Word;
    Affect : Array[1..MaxUpgrade] of Longint;

end;

Tmap_side = record
    header : SectionName;  {SIDE}
    l      : Longint;
    Players: Array[1..8] of byte;
    Filler : Array[1..7] of byte;
    Neutral: byte; {2h}
end;

Tmap_start = record
          Gold : record
              header : SectionName;  {SGLD}
              l      : Longint;
              Players: Array[1..8] of Word;
              Filler : Array[1..7] of Integer;
              Neutral: Integer;
          End;
          Wood : record
              header : SectionName;  {SLBR}
              l      : Longint;
              Players: Array[1..8] of Word;
              Filler : Array[1..7] of Integer;
              Neutral: Integer;
          End;
          Oil  : record
              header : SectionName;  {SOIL}
              l      : Longint;
              Players: Array[1..8] of Word;
              Filler : Array[1..7] of Integer;
              Neutral: Integer;
          End;
end;

Tmap_ai = record
    header : SectionName;  {AIPL}
    l      : Longint;
    Players: Array[1..8] of byte;
    Filler : Array[1..7] of byte;
    Neutral: byte; {0h}

end;


TMapInfo = Record
   pud:DosFileName;
   size:longint;
   ver:String[4];   {version of the game req.}
end;

TMapData= Record
map_type:Tmap_Type;
map_version:Tmap_version;
map_desc:Tmap_desc;
map_owner:Tmap_owner;
map_terrain:Tmap_terrain;
{1.33}
map_terrainX:tmap_terrain;
{----}
map_dim:Tmap_dim;
map_unitdata:Tmap_unitdata;
map_upgrade:Tmap_upgrade;
map_side:Tmap_side;
map_start:Tmap_start;
map_ai:Tmap_ai;
end;

Type
TNames = Array[0..MaxUnit-1] of String;
TUpg_names = Array[0..Maxupgrade-1] of String;
TProj_names = Array[0..MaxProj] Of String;
TAINames = Array[0..MaxAI-1] of String;
TSideName = Array[0..2] of String;
TColors = Array[1..8] of String;
TUnitType = Array[0..2] of string;
TMoveFlag = Array[0..6] of String;
TownerName =Array[1..7] of String;
TTerrainName = Array[0..3] of String;

Var
    Name:^TNames;       {global data}
    UName:^TUpg_Names;
    Proj:TProj_Names;
    AIName:TAINames;
    ColorName:TColors;
    RaceName:TSideName;
    UnitType:TUnitType;
    MoveFlag:TMoveFlag;
    OwnerName:TOwnerName;
    TerrainName:TTerrainName;
    Version: Array[1..4] of String;

    MX,MY:Integer;      {Mouse variables}
    MTX,MTY:Integer;    {They are global so no procs need to carry them}
    LBut,RBut:Boolean;  {MTX and MTY are Mouse X and Mouse Y in mode text}

    DirInfo:Array[0..300] of SearchRec;

    Ver133:Boolean;
    FileVer133:Boolean;

Procedure DefaultData; External; {$L DEFAULT.OBJ}
FUNCTION BHex( V :BYTE ) :STRING;
BEGIN
  BHex := HexList[V Shr 4] + HexList[V Mod 16];
END;

Procedure GetIni(Var Name:TNames; Var UName:TUpg_Names; Var Proj:TProj_Names);
Var I:Byte;
    num:string;
Begin
     GetProfileString('war2unit','Startup','Version',Version[1],'0.0');
     GetProfileString('war2unit','Startup','Revision',Version[2],'b000');
     GetProfileString('war2unit','Startup','Date',Version[3],'01/01/80');
     GetProfileString('war2unit','Startup','INIVersion',Version[4],'0.0');
     For I:=0 to Maxunit-1 do
         Begin
         GetProfileString('war2unit','UnitName',Bhex(i),Name[I],'<< EMPTY >>');
         end;
     For I:=0 to MaxUpgrade-1 do
         Begin
         GetProfileString('war2unit','UpgradeName',Bhex(i),UName[I],'<< EMPTY >>');
         end;
     For I:=0 to MaxProj do
         Begin
         GetProfileString('war2unit','Projectile',Bhex(i),Proj[I],'<< EMPTY >>');
         end;
     For I:=0 to MaxAI-1 do
         Begin
         GetProfileString('war2unit','AIName',Bhex(i),AIName[I],'<< EMPTY >>');
         end;
     For I:=0 to 2 do
         Begin
         GetProfileString('war2unit','Race',Bhex(i),RaceName[I],'<< EMPTY >>');
         end;
     For I:=0 to 2 do
         Begin
         GetProfileString('war2unit','UnitType',Bhex(i),UnitType[I],'<< EMPTY >>');
         end;
     For I:=1 to 8 do
         Begin
         GetProfileString('war2unit','Colors',Bhex(i),ColorName[I],'<< EMPTY >>');
         end;
     For I:=0 to 6 do
         Begin
         GetProfileString('war2unit','MoveFlag',Bhex(i),MoveFlag[I],'<NONE>');
         end;
     For I:=1 to 7 do
         Begin
         GetProfileString('war2unit','Owner',Bhex(i),OwnerName[I],'<NONE>');
         end;
     For I:=0 to 3 do
         Begin
         GetProfileString('war2unit','Terrain',Bhex(i),TerrainName[I],'<NONE>');
         end;

End;


Procedure UnderLine(X1,X2,Y,Attr:Byte);
Var I:Integer;
    O:Word;
Begin;

    For I:=X1 to X2 Do
       Begin
        O:=((Y-1)*160)+(2*I-1);
        Mem[$B800:O]:=Attr
       End;

End;


Procedure Scroll ({input } Direction : Integer;
                          Lines2Scroll,
                          Rowtop,
                          RowBot,
                          ColStart,
                          ColStop,
                          FillAttr : Byte);
Begin
  If (Direction = - 1) Then
    Asm
      mov AH, 06h
      mov AL, Lines2Scroll
      mov BH, FillAttr
      mov CH, Rowtop
      mov CL, ColStart
      mov DH, RowBot
      mov DL, ColStop
      Int 10h
    End
  Else
    Asm
      mov AH, 07h
      mov AL, Lines2Scroll
      mov BH, FillAttr
      mov CH, Rowtop
      mov CL, ColStart
      mov DH, RowBot
      mov DL, ColStop
      Int 10h
    End
End; { Scroll }

{***********************INPUT ROUTINES************************************}

Function IntToStr(I: Longint): String;
{ Convert any integer type to a string }
var
  S: string[11];
begin
  Str(I, S);
  IntToStr := S;
 end;

Function DecBin(N:Longint):String;
Var B:Longint;
    I:Longint;
    S:String;
Begin
     S[0]:=Chr(32);
     For I:=31 downto 0 do If (N and (1 shl I)) - (1 shl I) = 0 then S[32-i]:='1' else S[32-i]:='0';
     DecBin := S;
end;

Procedure GetStr(X,Y:Integer; Var S:String; L:Byte);
Var I:Byte;
    Done:Boolean;
    C:Char;
    TmpStr:String;
Begin
     S:='';
     Done:=false;
     gotoxy(x,y);
     I:=0;
     repeat
     c:=#0;
     If (RightButton = True) then Done:=True;

     If Keypressed Then c := Getkey;
     case c of
          down,up,chr(13):begin
                done:=true;
                S:=TmpStr;
                end;
          esc:  begin
                done:=true;
                end;
          Chr(0):;
          Chr(8):Begin
                 If I >= 1 Then
                    Begin
                    gotoxy(wherex-1,y);
                    write(' ');
                    gotoxy(wherex-1,y);
                    TmpStr[I]:=#0;
                    dec(i);
                    TmpStr[0]:=Chr(I);
                    End;
                 end;
          else Begin
               If I < L Then
               Begin
                    write(c);
                    inc(I);
                    TmpStr[I]:=C;
                    TmpStr[0]:=Chr(I);
               End;
               end;
     END(*CASE*);

     until done;
End;

Procedure GetInteger(Var N:Word;X,Y:Integer;Min,Max:Longint);
Var OldX,OldY:Integer;
    OldN:Integer;
    I:Integer;
    Errcode:Integer;
    Var Number:String;
Begin
CursorON;
OldX:=WhereX;
OldY:=WhereY;
GotoXY(X,Y);
For I:=1 to 5 do Write(' ');
OldN:=N;

GetStr(X,Y,Number,5);
val(Number,N,Errcode);
If (Errcode <> 0) or (N > Max) or (N < Min) then N:=OldN;

GotoXY(OldX,OldY);
CursorOFF;
End;

Procedure GetLong(Var N:Longint;X,Y:Integer;Min,Max:Longint);
Var OldX,OldY:Integer;
    OldN:Longint;
    I:Integer;
    Errcode:Integer;
    Var Number:String;
Begin
CursorON;
OldX:=WhereX;
OldY:=WhereY;
GotoXY(X,Y);
For I:=1 to 5 do Write(' ');
OldN:=N;

GetStr(X,Y,Number,5);
val(Number,N,Errcode);
If (Errcode <> 0) or (N > Max) or (N < Min) then N:=OldN;

GotoXY(OldX,OldY);
CursorOFF;
End;

Procedure GetByte(Var N:Byte;X,Y:Integer;Min,Max:Longint);
Var OldX,OldY:Integer;
    OldN:Byte;
    I:Integer;
    Errcode:Integer;
    Var Number:String;
Begin
CursorON;
OldX:=WhereX;
OldY:=WhereY;
GotoXY(X,Y);
For I:=1 to 5 do Write(' ');
OldN:=N;

GetStr(X,Y,Number,3);
val(Number,N,Errcode);
If Errcode <> 0 then N:=OldN;
If (Errcode <> 0) or (N > Max) or (N < Min) then N:=OldN;

GotoXY(OldX,OldY);
CursorOFF;
End;


Procedure IncrementW(Var Number:Word; Value,Low,high:Integer);
Begin;
If (Number + Value > High) Then Number:=High else
   inc(Number,Value);
if number < low then number := low;
if number > high then number := high;
end;

Procedure IncrementB(Var Number:Byte; Value,Low,high:Byte);
Begin;
If (Number + Value > High) Then Number:=High else
   inc(Number,Value);
if number < low then number := low;
if number > high then number := high;
end;


Procedure IncrementD(Var Number:Longint; Value,Low,high:Longint);
Begin;
If (Number + Value > High) Then Number:=High else
   inc(Number,Value);
if number < low then number := low;
if number > high then number := high;
end;

Procedure DecrementD(Var Number:Longint; Value,Low,high:Longint);
Begin;
If (Integer(Number - Value) < Low) Then Number:=Low else
   if number > low then dec(Number,Value);
if number < low then number := low;
if number > high then number := high;
end;

Procedure DecrementB(Var Number:Byte; Value,Low,high:Byte);
Begin;
If (Integer(Number - Value) < Low) Then Number:=Low else
   if number > low then dec(Number,Value);
if number < low then number := low;
if number > high then number := high;
end;



Procedure DecrementW(Var Number:Word; Value,Low,high:Integer);
Begin;
If (Integer(Number - Value) < Low) Then Number:=Low else
   if number > low then dec(Number,value);
if number < low then number := low;
if number > high then number := high;
end;


Procedure ToggleB(Var Number:Byte; Bit:Byte);
Begin
If Number and (1 shl bit) div (1 shl bit) = 1 Then Number := Number - (1 shl bit)
   Else Number := Number + (1 shl bit);
Repeat
Until LeftButton = False;  {prevent too fast toggle with mouse}
end;


Procedure ToggleD(Var Number:Word; Bit:Byte);
Begin
If (Number and (1 shl bit)) - (1 shl bit) = 0 Then Number := Number - (1 shl bit)
   Else Number := Number + (1 shl bit);
Repeat
Until LeftButton = False;
end;

Procedure ToggleL(Var Number:Longint; Bit:Longint);
Begin
If Bit < 31 then Begin
If (Number and (1 shl bit)) - (1 shl bit) = 0 Then Number := Number - (1 shl bit)
   Else Number := Number + (1 shl bit);
End;
Repeat
Until LeftButton = False;
end;

Procedure SwitchB(Var Number:Byte;Min,Max:Integer);
Begin
Inc(Number);
If (Number > Max) Then Number:=Min;
If (Number < Min) Then Number:=Max;
Repeat
Until LEftButton = False;  {prevent too fast toggle with mouse}
end;


{MOUSE EVENT}
Procedure GetMouseEvent(Section:Byte;Var Choix:Integer;Var Mapdata:Tmapdata);
Var OldX,OLdY:Integer;
    Temp:Word;
Begin
     OlDX:=WhereX;
     OldY:=WhereY;
   MouseText(MTX,MTY,Lbut,Rbut);
{     GotoXY(70,25);
     Write(MTX,':',MTY);}
     Case Section of
     0:Case MTY of
       2:Case MTX of
         30..41:GetInteger(mapdata.map_unitdata.HP[Choix+1],37,2,0,32000);
         45..78:SwitchB(mapdata.map_unitdata.Projectile[Choix+1],0,50);
         END(*CASE 1.1.1*);
         3:Case MTX of
         30..41:GetByte(mapdata.map_unitdata.Basic[Choix+1],37,3,0,255);
         45..54:ToggleB(mapdata.map_unitdata.Up_Armor[choix+1],0);
         62..78:GetByte(mapdata.map_unitdata.ReactRange[choix+1],75,3,0,255);
         END(*CASE 1.1.1*);
         4:Case MTX of
         30..41:GetByte(mapdata.map_unitdata.Piercing[Choix+1],37,4,0,255);
         45..54:ToggleB(mapdata.map_unitdata.up_weap[choix+1],0);
         62..78:GetByte(mapdata.map_unitdata.PlayerReact[choix+1],75,4,0,255);
         END(*CASE 1.1.1*);
         5:Case MTX of
         30..41:GetByte(mapdata.map_unitdata.Armor[Choix+1],37,5,0,255);
         45..58:GetInteger(mapdata.map_unitdata.Kill[Choix+1],54,5,0,1000);
         62..78:GetByte(mapdata.map_unitdata.AnnoyCPU[choix+1],75,5,0,255);
         END(*CASE 1.1.1*);
         6:Case MTX of
         30..41:GetByte(mapdata.map_unitdata.Range[Choix+1],37,6,0,255);
         45..58:GetByte(mapdata.map_unitdata.Decay[Choix+1],54,6,0,255);
         62..78:SwitchB(mapdata.map_unitdata.movement[choix+1],1,6);
         END(*CASE 1.1.1*);
         7:Case MTX of
         30..41:GetLong(mapdata.map_unitdata.Sight[Choix+1],37,7,0,10);
         45..58:If Choix < 58 Then SwitchB(mapdata.map_unitdata.UnitType[Choix+1],0,2);
         62..78:GetInteger(mapdata.map_unitdata.UnitSize[choix+1].X,75,7,1,10);
         END(*CASE 1.1.1*);
         8:Case MTX of
         30..41:GetByte(mapdata.map_unitdata.BuildTime[Choix+1],37,8,0,255);
         45..59:GetByte(mapdata.map_unitdata.Priority[Choix+1],56,8,0,255);
         62..78:GetInteger(mapdata.map_unitdata.UnitSize[choix+1].Y,75,8,1,10);
         END(*CASE 1.1.1*);
         9:Case MTX of
         30..41:Begin
                     Temp:=mapdata.map_unitdata.Gold[Choix+1]*10;
                     GetInteger(Temp,37,9,0,2550);
                     If Temp <> 0 Then
                        Begin
                        mapdata.map_unitdata.Gold[Choix+1] := Temp Div 10;
                        End Else mapdata.map_unitdata.Gold[Choix+1] := 0;
                End;
         45..56:ToggleB(mapdata.map_unitdata.Tag[choix+1],0);
         62..78:GetInteger(mapdata.map_unitdata.BoxSize[choix+1].X,75,9,1,10);
         END(*CASE 1.1.1*);
        10:Case MTX of
         30..41:Begin
                     Temp:=mapdata.map_unitdata.Wood[Choix+1]*10;
                     GetInteger(Temp,37,10,0,2550);
                     If Temp <> 0 Then
                        Begin
                        mapdata.map_unitdata.Wood[Choix+1] := Temp Div 10;
                        End Else mapdata.map_unitdata.Wood[Choix+1] := 0;
                End;
         45..59:ToggleB(mapdata.map_unitdata.Target[choix+1],0);
         62..78:GetInteger(mapdata.map_unitdata.BoxSize[choix+1].Y,75,10,1,10);
         END(*CASE 1.1.1*);
        11:Case MTX of
         30..41:Begin
                     Temp:=mapdata.map_unitdata.Oil[Choix+1]*10;
                     GetInteger(Temp,37,11,0,2550);
                     If Temp <> 0 Then
                        Begin
                        mapdata.map_unitdata.Oil[Choix+1] := Temp Div 10;
                        End Else mapdata.map_unitdata.Oil[Choix+1] := 0;
                End;
         45..59:ToggleB(mapdata.map_unitdata.Target[choix+1],1);
         62..78:GetInteger(mapdata.map_unitdata.Frame[choix+1],75,11,0,255);
         END(*CASE 1.1.1*);
        12:Case MTX of
         30..41:ToggleB(mapdata.map_unitdata.magician[choix+1],0);
         45..59:ToggleB(mapdata.map_unitdata.Target[choix+1],2);
         END(*CASE 1.1.1*);
        16:Case MTX of
         30..36:ToggleD(mapdata.map_unitdata.flags[choix+1,1],0);
         40..46:ToggleD(mapdata.map_unitdata.flags[choix+1,1],8);
         50..56:ToggleD(mapdata.map_unitdata.flags[choix+1,2],0);
         60..66:ToggleD(mapdata.map_unitdata.flags[choix+1,2],8);
           END(*CASE 1.1.1*);
        17:Case MTX of
         30..36:ToggleD(mapdata.map_unitdata.flags[choix+1,1],1);
         40..46:ToggleD(mapdata.map_unitdata.flags[choix+1,1],9);
         50..56:ToggleD(mapdata.map_unitdata.flags[choix+1,2],1);
         60..66:ToggleD(mapdata.map_unitdata.flags[choix+1,2],9);
           END(*CASE 1.1.1*);
        18:Case MTX of
         30..36:ToggleD(mapdata.map_unitdata.flags[choix+1,1],2);
         40..46:ToggleD(mapdata.map_unitdata.flags[choix+1,1],10);
         50..56:ToggleD(mapdata.map_unitdata.flags[choix+1,2],2);
         60..66:ToggleD(mapdata.map_unitdata.flags[choix+1,2],10);
           END(*CASE 1.1.1*);
        19:Case MTX of
         30..36:ToggleD(mapdata.map_unitdata.flags[choix+1,1],3);
         40..46:ToggleD(mapdata.map_unitdata.flags[choix+1,1],11);
         50..56:ToggleD(mapdata.map_unitdata.flags[choix+1,2],3);
         60..66:ToggleD(mapdata.map_unitdata.flags[choix+1,2],11);
           END(*CASE 1.1.1*);
        20:Case MTX of
         30..36:ToggleD(mapdata.map_unitdata.flags[choix+1,1],4);
         40..46:ToggleD(mapdata.map_unitdata.flags[choix+1,1],12);
         50..56:ToggleD(mapdata.map_unitdata.flags[choix+1,2],4);
         60..66:ToggleD(mapdata.map_unitdata.flags[choix+1,2],12);
          END(*CASE 1.1.1*);
        21:Case MTX of
         30..36:ToggleD(mapdata.map_unitdata.flags[choix+1,1],5);
         40..46:ToggleD(mapdata.map_unitdata.flags[choix+1,1],13);
         50..56:ToggleD(mapdata.map_unitdata.flags[choix+1,2],5);
         60..66:ToggleD(mapdata.map_unitdata.flags[choix+1,2],13);
          END(*CASE 1.1.1*);
        22:Case MTX of
         30..36:ToggleD(mapdata.map_unitdata.flags[choix+1,1],6);
         40..46:ToggleD(mapdata.map_unitdata.flags[choix+1,1],14);
         50..56:ToggleD(mapdata.map_unitdata.flags[choix+1,2],6);
         60..66:ToggleD(mapdata.map_unitdata.flags[choix+1,2],14);
          END(*CASE 1.1.1*);
        23:Case MTX of
         30..36:ToggleD(mapdata.map_unitdata.flags[choix+1,1],7);
         40..46:ToggleD(mapdata.map_unitdata.flags[choix+1,1],15);
         50..56:ToggleD(mapdata.map_unitdata.flags[choix+1,2],7);
         60..66:ToggleD(mapdata.map_unitdata.flags[choix+1,2],15);
          END(*CASE 1.1.1*);
         END(*CASE 1.1.1*);

     1:Case MTY of
       5:Case MTX of
         45..63:GetByte(mapdata.map_upgrade.time[choix+1],59,5,0,255);
         END(*CASE 1.1.1*);
       6:Case MTX of
         45..63:GetInteger(mapdata.map_upgrade.gold[choix+1],59,6,0,65000);
         END(*CASE 1.1.1*);
       7:Case MTX of
         45..63:GetInteger(mapdata.map_upgrade.wood[choix+1],59,7,0,65000);
         END(*CASE 1.1.1*);
       8:Case MTX of
         45..63:GetInteger(mapdata.map_upgrade.oil[choix+1],59,8,0,65000);
         END(*CASE 1.1.1*);
       9:Case MTX of
         45..63:GetInteger(mapdata.map_upgrade.icon[choix+1],59,9,0,500);
         END(*CASE 1.1.1*);
       10:Case MTX of
         45..63:GetInteger(mapdata.map_upgrade.group[choix+1],59,10,0,20);
         END(*CASE 1.1.1*);
       12:Case MTX of
         44..68:If mapdata.map_upgrade.Affect[choix+1] > 2000000 then mapdata.map_upgrade.Affect[choix+1] := 1
                Else Begin
                mapdata.map_upgrade.Affect[choix+1]:=mapdata.map_upgrade.Affect[choix+1]shl 1;
                repeat until LeftButton = False;
                End;
          END(*CASE 1.1.1*);
       13:Case MTX of
          44..76:ToggleL(mapdata.map_upgrade.Affect[choix+1],76-MTX);  {BIT toggle}
          END(*CASE 1.1.1*);
       END(*CASE 1.1*);
      2:Case MTY of
        5:Case MTX of
          1..28: Begin
               Inc(Choix);
               If Choix > 8 Then Choix := 1;
               Repeat Until LeftButton = False;
               End;
          END(*CASE 1.1.1*);
        6:Case MTX of
          1..28:Begin
                   Inc(mapdata.map_side.players[Choix]);
                   If mapdata.map_side.players[Choix] > 2 Then mapdata.map_side.players[Choix] := 00;
                   Repeat Until LeftButton = False;
                End;
          END(*CASE 1.1.1*);
        7:Case MTX of
          1..28:Begin
                   Inc(mapdata.map_owner.slot[Choix]);
                   If mapdata.map_owner.slot[Choix] > 7 Then mapdata.map_owner.slot[Choix] := 01;
                   Repeat Until LeftButton = False;
                End;
          END(*CASE 1.1.1*);
        8:Case MTX of
          1..28:Begin
                   Inc(mapdata.map_ai.Players[Choix]);
                   If mapdata.map_ai.players[Choix] > MaxAi Then mapdata.map_ai.players[Choix] := 00;
                   Repeat Until LeftButton = False;
                End;
          END(*CASE 1.1.1*);
        9:Case MTX of
          1..22:Begin
                Getinteger(mapdata.map_start.wood.players[Choix],18,9,0,65000);
                End;
          END(*CASE 1.1.1*);
        10:Case MTX of
          1..22:Begin
                Getinteger(mapdata.map_start.wood.players[Choix],18,10,0,65000);
                End;
          END(*CASE 1.1.1*);
        11:Case MTX of
          1..22:Begin
                Getinteger(mapdata.map_start.wood.players[Choix],18,11,0,65000);
                End;
          END(*CASE 1.1.1*);
        END(*CASE 1.1*);
     3:Case MTY of
       8..21:Case MTX of
             30..56: Choix:=MTY-7;
             END(*CASE 1.1.1 *)
       END(*CASE 1.1*)
     END(*CASE 1*);

     Repeat Until LeftButton = False;
     GotoXY(OldY,OldY);
End;
{--END--}

Procedure ShowMapInfo(Var Mapinfo:Tmapinfo; Var Mapdata:TmapData);
Var I:integer;
    C,C2:Char;
    OldChoix,Choix:Byte;
    TmpDesc:Array[1..31] of char;
    P:integer;
    Done:Boolean;
Begin
MouseOFF;
I:=0;
Choix:=1;
OldChoix:=0;
repeat
clrscr;


If mapdata.map_terrain.terrain = 3 Then Mapinfo.Ver:='1.3' else Mapinfo.Ver:='1.0';
if (Ver133 = True) then Mapinfo.Ver:='1.33';

GotoXY(30,1);
Writeln('Map informations');

GotoXY(1,3);
if (Ver133 = True) Then Write('v1.33 PUD   ')
Else If mapdata.map_unitdata.l = NormalSize Then Write('Normal PUD  ')
Else If mapdata.map_unitdata.l = ExpSize Then Write('Built-in PUD   ');

GotoXY(1,4);
Writeln('Map version: ',Bhex(mapdata.map_version.version));
GotoXY(1,5);
Writeln('Map Name   : ',mapinfo.pud:12,'     Map Size: ',mapinfo.size:6,
                                           '     ','Version Req.: ',mapinfo.ver:4);
Writeln('Dimension  : ',mapdata.map_dim.x,'x',mapdata.map_dim.y);
Writeln('Default Unit : ',YN[mapdata.map_unitdata.default],'              Upgrade : ',YN[mapdata.map_upgrade.default]);
gotoXY(1,8);
Write('Terrain    : ',TerrainName[mapdata.map_terrain.terrain],'        ');
If (Ver133 = True) Then Write(TerrainName[mapdata.map_terrainX.terrain],'(v1.33)')
   Else Write('                      ');
gotoXY(1,9);
Write('Description: ');
gotoXY(1,10);
Write('Make it 1.33 ');
I:=0;
MouseON;
gotoxy(14,9);
repeat
inc(i);
write(mapdata.map_desc.description[i]);
until mapdata.map_desc.description[i] = Chr(0);
Write('                          ');
          Underline(1,12,7+Choix,$1B);
          OldChoix:=Choix;
c:=getkey;
          case c of
          down:inc(Choix);
          Up:Dec(Choix);
          Left:;
          Right:;
          Chr(13):Begin
                  Case Choix of
                  1:Begin
                    If Ver133 = True Then Begin
                       Ver133:=False;
                       mapdata.map_terrain.terrain := 0;

                       mapdata.map_version.version:=$11;

                       End Else Begin
                           Inc(mapdata.map_terrain.terrain);
                           if mapdata.map_terrain.terrain > 3 then mapdata.map_terrain.terrain := 0;
                       End;
                    End;
                  2:Begin
                    Underline(1,12,7+Choix,$7);
                    CursorON;
                    GotoXY(14,9);
                    For I:=1 to 31 do Write(' ');
                    Done:=false;
                    GotoXY(14,9);
                    For I:=1 to 32 do Tmpdesc[I]:=Chr(00);
                    p:=1;
                    Repeat
                      C2:=Getkey;
                          Case C2 of
                           ' '..'Z','a'..'z':
                                    Begin
                                    if p < 32 Then
                                       Begin
                                       write(c2);
                                       TmpDesc[P]:=c2;
                                       inc(p);
                                       end;
                                    end;
                           Chr(8): Begin
                                   If p > 1 then
                                      Begin
                                      GotoXY(WhereX-1,9);
                                      Write(' ');
                                      GotoXY(WhereX-1,9);
                                      Dec(p);
                                      TmpDesc[P]:=Chr(00);
                                      End;
                                   End;
                           Left:If P > 1 Then
                                   Begin
                                   Dec(p);
                                   GotoXY(WhereX-1,WhereY);
                                   End;
                           Right:If P < 31 Then
                                   Begin
                                   Inc(p);
                                   GotoXY(WhereX+1,WhereY);
                                   End;

                           Chr(13): Begin
                                    For I:=1 to 32 do
                                        mapdata.map_desc.description[I]:=tmpdesc[I];
                                    Done:=True;
                                    End;
                           Chr(27): Done:=True;
                          END(*CASE*)

                    until Done;
                    CursorOFF;
                    Underline(1,12,7+Choix,$1b);
                    end;
                  3:Begin
                    If Ver133 = False Then Begin
                       Ver133:= True;
                       mapdata.map_terrain.terrain := 2;
                       mapdata.map_terrainX.terrain := 3;
                       mapdata.map_terrainX.l := 2;
                       mapdata.map_terrainX.header[1]:='E';
                       mapdata.map_terrainX.header[2]:='R';
                       mapdata.map_terrainX.header[3]:='A';
                       mapdata.map_terrainX.header[4]:='X';
                       mapdata.map_version.version:=$13;
                       End;

                    End;

                  END;(*CASE*)
                  End;
          END;
          If Choix > 3 Then Choix:=1;
          If Choix < 1 Then Choix:=3;
          Underline(1,12,7+OldChoix,$7);
until c=chr(27);


end;

Procedure RestoreUnit(Var Choix:Integer;Var Mapdata:Tmapdata);
Var Temp:Tmap_UnitData;
Begin
FillChar(Temp,Sizeof(Temp),0);
Move(Pointer(@DefaultData)^,temp.default,mapdata.map_unitdata.l);

with mapdata.map_unitdata do
Begin
                   Sight[Choix+1]:=Temp.Sight[Choix+1];
                   HP[Choix+1]:=Temp.HP[Choix+1];
                   Magician[Choix+1]:=Temp.Magician[Choix+1];
                   Buildtime[Choix+1]:=Temp.BuildTime[Choix+1];
                   Gold[Choix+1]:=Temp.Gold[Choix+1];
                   Wood[Choix+1]:=Temp.Wood[Choix+1];
                   Oil[Choix+1]:=Temp.Oil[Choix+1];
                   UnitSize[Choix+1].X:=Temp.UnitSize[Choix+1].X;
                   UnitSize[Choix+1].y:=Temp.UnitSize[Choix+1].y;
                   BoxSize[Choix+1].X:=Temp.BoxSize[Choix+1].X;
                   BoxSize[Choix+1].y:=Temp.BoxSize[Choix+1].y;
                   Range[Choix+1]:=Temp.Range[Choix+1];
                   ReactRange[Choix+1]:=Temp.ReactRange[Choix+1];
                   PlayerReact[Choix+1]:=Temp.PlayerReact[Choix+1];
                   Armor[Choix+1]:=Temp.Armor[Choix+1];
                   Tag[Choix+1]:=Temp.Tag[Choix+1];
                   Priority[Choix+1]:=Temp.Priority[Choix+1];  {0 = high  255 = low}
                   Basic[Choix+1]:=Temp.Basic[Choix+1];
                   Piercing[Choix+1]:=Temp.Piercing[Choix+1];
                   Up_weap[Choix+1]:=Temp.Up_Weap[Choix+1];
                   Up_armor[Choix+1]:=Temp.Up_armor[Choix+1];
                   Projectile[Choix+1]:=Temp.Projectile[Choix+1];
                   UnitType[Choix+1]:=Temp.UnitType[Choix+1];
                   Decay[Choix+1]:=Temp.Decay[Choix+1];
                   AnnoyCPU[Choix+1]:=Temp.AnnoyCPU[Choix+1];
                   If Choix+1 < 58 Then Movement[Choix+1]:=Temp.Movement[Choix+1];
                   Kill[Choix+1]:=Temp.Kill[Choix+1];
                   Target[Choix+1]:=Temp.Target[Choix+1];
                   Flags[Choix+1,1]:=Temp.Flags[Choix+1,1];
                   Flags[Choix+1,2]:=Temp.Flags[Choix+1,2];
                  Sound(100);
                  Delay(50);
                  Nosound;
End;
{map_unitdata}
{map_type:Tmap_Type;
map_version:Tmap_version;
map_desc:Tmap_desc;
map_owner:Tmap_owner;
map_terrain:Tmap_terrain;
map_dim:Tmap_dim;
map_unitdata:Tmap_unitdata;
map_upgrade:Tmap_upgrade;
}
End;

Procedure RestoreUpgrade(Var Choix:Integer; Var mapdata:Tmapdata);
Var Temp:Tmap_Upgrade;
Begin
FillChar(Temp,Sizeof(Temp),0);
Move(Pointer(Longint(@DefaultData)+mapdata.map_unitdata.l)^,temp.default,mapdata.map_upgrade.l);
                   With Mapdata.map_upgrade Do
                        Begin
                        Time[Choix+1]:=Temp.Time[Choix+1];
                        Gold[Choix+1]:=Temp.Gold[Choix+1];
                        Wood[Choix+1]:=Temp.Wood[Choix+1];
                        Oil[Choix+1]:=Temp.Oil[Choix+1];
                        Icon[Choix+1]:=Temp.Icon[Choix+1];
                        Group[Choix+1]:=Temp.Group[Choix+1];
                        Affect[Choix+1]:=Temp.Affect[Choix+1];
                        End;
                  Sound(100);
                  Delay(50);
                  Nosound;

End;

{*******************************  UNITS  ************************************}

Procedure EditUnit(Var Mapdata:Tmapdata);
    Procedure Redraw(Var Choix,Old:Integer);
    Var I:byte;
        Diff:Integer;
        X,Y:Integer;
    Begin
MouseOff;
{SetmousePos(8*28,1*8);}

    UnderLine(1,25,WhereY,7);
    Y:=WhereY;
    Diff:=Abs(Choix-Old);
    If Choix > MaxUnit-1 Then Choix := MaxUnit-1;
    If Choix < 0 Then Choix := 0;
    If Choix < Old Then Y:=(Y-Diff) Else If Choix > Old Then Y:=(Y+Diff);
       If (Y = 0) {and (Choix-1<>0)} Then
       Begin
       Scroll(1,Diff,0,23,0,25,$7);
       Y:=1;
       GotoXY(1,Y);
       Write(Bhex(Choix),'-',name^[Choix],'          ');
       End;
   If Y = 25 Then
   Begin
   Scroll(-1,Diff,0,23,0,25,$7);
   Y:=24;
   GotoXY(1,Y);
   Write(Bhex(Choix),'-',name^[Choix],'          ');
   End;
   Underline(1,25,Y,$4f);
   GotoXY(1,Y);
   MouseOn;
   end;


Procedure StatScreen(Var Choix:Integer);
Var OldX,OldY:Integer;
Begin
MouseOFF;

OldX:=WhereX; OldY:=WhereY;
GotoXY(30,1);
Write(name^[Choix],'                ');
GotoXY(30,2);
Write('hp   : ',mapdata.map_unitdata.HP[Choix+1]:5);
underline(30,30,2,$F);
GotoXY(30,3);
Write('B_Dmg: ',mapdata.map_unitdata.Basic[Choix+1]:5);
underline(30,30,3,$F);
GotoXY(30,4);
Write('P_Dmg: ',mapdata.map_unitdata.Piercing[Choix+1]:5);
underline(32,32,4,$F);
{(Basic_Damage - Enemy_Armor) + Piercing_Damage = Maximum possible  (50%))}
{Upgrade raise piercing damage}
GotoXY(30,5);
Write('Armor: ',mapdata.map_unitdata.Armor[Choix+1]:5);
underline(30,30,5,$F);
GotoXY(30,6);
Write('Range: ',mapdata.map_unitdata.Range[Choix+1]:5);
underline(30,30,6,$F);
GotoXY(30,7);
Write('Sight: ',mapdata.map_unitdata.Sight[Choix+1]:5);
underline(30,30,7,$F);
GotoXY(30,8);
Write('Time : ',mapdata.map_unitdata.BuildTime[Choix+1]:5);
underline(31,31,8,$F);
GotoXY(30,9);
Write('Gold : ',mapdata.map_unitdata.Gold[Choix+1]*10:5);
underline(30,30,9,$F);
GotoXY(30,10);
Write('Wood : ',mapdata.map_unitdata.Wood[Choix+1]*10:5);
underline(30,30,10,$F);
GotoXY(30,11);
Write('Oil  : ',mapdata.map_unitdata.Oil[Choix+1]*10:5);
underline(30,30,11,$F);
GotoXY(30,12);
Write('Magic: ',YN[mapdata.map_unitdata.magician[choix+1]]:5);
underline(34,34,12,$F);

GotoXY(45,2);
Write('Missile: ',Bhex(mapdata.map_unitdata.Projectile[Choix+1]),'-',
                Proj[mapdata.map_unitdata.Projectile[Choix+1]]:17);
underline(45,45,2,$F);
GotoXY(45,3);
Write('ArmorUp: ',YN[mapdata.map_unitdata.up_armor[choix+1]]:1);
underline(50,50,3,$F);
GotoXY(45,4);
Write('WeapnUp: ',YN[mapdata.map_unitdata.up_weap[choix+1]]:1);
underline(46,46,4,$F);
GotoXY(45,5);
Write('Value  : ',mapdata.map_unitdata.kill[choix+1]:5);
underline(45,45,5,$F);
GotoXY(45,6);
Write('Decay  : ',mapdata.map_unitdata.decay[choix+1]:5);
underline(49,49,6,$F);
GotoXY(45,7);
Write('Type   : ',UnitType[mapdata.map_unitdata.unittype[choix+1]]:5);
underline(45,45,7,$F);
GotoXY(45,8);
Write('Priority : ',mapdata.map_unitdata.priority[choix+1]:3);
underline(45,45,8,$F);
GotoXY(45,9);
Write('Rectangle: ',YN[mapdata.map_unitdata.tag[choix+1]]);
underline(50,50,9,$F);
GotoXY(45,10);
Write('Target Land : ',YN[mapdata.map_unitdata.target[choix+1] and $1 Div $1]);
underline(52,52,10,$F);
GotoXY(45,11);
Write('ZTarget Sea : ',YN[mapdata.map_unitdata.target[choix+1] and $2 Div $2]);
underline(45,45,11,$F);
GotoXY(45,12);
Write('KTarget Air : ',YN[mapdata.map_unitdata.target[choix+1] and $4 Div $4]);
underline(45,45,12,$F);


GotoXY(62,3);
Write('JCPU  react : ',mapdata.map_unitdata.ReactRange[choix+1]:3);
underline(62,62,3,$F);
GotoXY(62,4);
Write('XPlyr react : ',mapdata.map_unitdata.PlayerReact[choix+1]:3);
underline(62,62,4,$F);
GotoXY(62,5);
Write('QAnnoy CPU? : ',mapdata.map_unitdata.annoyCPU[choix+1]:3);
underline(62,62,5,$F);


GotoXY(62,6);
If Choix < 58 Then
Begin
Write('MovFlag: ',MoveFlag[mapdata.map_unitdata.movement[choix+1]]:8);
underline(65,65,6,$F);
End Else Write('                  ');


GotoXY(62,7);
Write('-Size:     X=',mapdata.map_unitdata.UnitSize[choix+1].X:3);
underline(62,62,7,$F);
GotoXY(62,8);
Write('=Size:     Y=',mapdata.map_unitdata.UnitSize[choix+1].Y:3);
underline(62,62,8,$F);
GotoXY(62,9);
Write('9Box Size: X=',mapdata.map_unitdata.BoxSize[choix+1].X:3);
underline(62,62,9,$F);
GotoXY(62,10);
Write('0Box Size: Y=',mapdata.map_unitdata.BoxSize[choix+1].Y:3);
underline(62,62,10,$F);
GotoXY(62,11);
Write('F10-Frame   : ',mapdata.map_unitdata.Frame[choix+1]:3);
underline(62,64,11,$F);
GotoXY(62,12);

with mapdata.map_unitdata do
Begin
GotoXY(30,15);
Write('[1..8]    [F1..F8] [SF1..SF8][AF1..AF8]');
underline(31,31,15,$F);
underline(34,34,15,$F);
underline(41,42,15,$F);
underline(45,46,15,$F);
underline(50,52,15,$F);
underline(55,57,15,$F);
underline(60,62,15,$F);
underline(65,67,15,$F);

GotoXY(30,16);
Write('Land :',YN[flags[Choix+1,1]and $1 div 1]);
GotoXY(30,17);
Write('Air  :',YN[flags[Choix+1,1] and $2 div 2]);
GotoXY(30,18);
Write('Expld:',YN[flags[Choix+1,1] and $4 div 4]);
GotoXY(30,19);
Write('Sea  :',YN[flags[Choix+1,1] and $8 div 8]);
GotoXY(30,20);
Write('Critt:',YN[flags[Choix+1,1] and 16 div 16]);
GotoXY(30,21);
Write('Build:',YN[flags[Choix+1,1] and 32 div 32]);
GotoXY(30,22);
Write('IsSub:',YN[flags[Choix+1,1] and 64 div 64]);
GotoXY(30,23);
Write('Csub :',YN[flags[Choix+1,1] and 128 div 128]);

GotoXY(40,16);
Write('Peon :',YN[flags[Choix+1,1] and 256 div 256]);
GotoXY(40,17);
Write('Tankr:',YN[flags[Choix+1,1] and 512 div 512]);
GotoXY(40,18);
Write('Trans:',YN[flags[Choix+1,1] and 1024 div 1024]);
GotoXY(40,19);
Write('O_Rig:',YN[flags[Choix+1,1] and 2048 div 2048]);
GotoXY(40,20);
Write('DepG :',YN[flags[Choix+1,1] and 4096 div 4096]);
GotoXY(40,21);
Write('NONE :',YN[flags[Choix+1,1] and 8192 div 8192]);
GotoXY(40,22);
Write('G.att:',YN[flags[Choix+1,1] and 16384 div 16384]);
GotoXY(40,23);
Write('udead:',YN[flags[Choix+1,1] and 32768 div 32768]);

{1-2-4-8-10h-20h-40h-80h}
GotoXY(50,16);
Write('Shore:',YN[flags[Choix+1,2] and (1 shl 0) div (1 shl 0)]);
GotoXY(50,17);
Write('Spell:',YN[flags[Choix+1,2] and (1 shl 1) div (1 shl 1)]);
GotoXY(50,18);
Write('DepW :',YN[flags[Choix+1,2] and (1 shl 2) div (1 shl 2)]);
GotoXY(50,19);
Write('Attck:',YN[flags[Choix+1,2] and (1 shl 3) div (1 shl 3)]);
GotoXY(50,20);
Write('Tower:',YN[flags[Choix+1,2] and (1 shl 4) div (1 shl 4)]);
GotoXY(50,21);
Write('Patch:',YN[flags[Choix+1,2] and (1 shl 5) div (1 shl 5)]);
GotoXY(50,22);
Write('Mine :',YN[flags[Choix+1,2] and (1 shl 6) div (1 shl 6)]);
GotoXY(50,23);
Write('Hero :',YN[flags[Choix+1,2] and (1 shl 7) div (1 shl 7)]);

GotoXY(60,16);
Write('DepO :',YN[flags[Choix+1,2] and (1 shl 8) div (1 shl 8)]);
GotoXY(60,17);
Write('Sappr:',YN[flags[Choix+1,2] and (1 shl 9) div (1 shl 9)]);
GotoXY(60,18);
Write('Mage :',YN[flags[Choix+1,2] and (1 shl 10) div (1 shl 10)]);
GotoXY(60,19);
Write('Alive:',YN[flags[Choix+1,2] and (1 shl 11) div (1 shl 11)]);
GotoXY(60,20);
Write('NONE :',YN[flags[Choix+1,2] and (1 shl 12) div (1 shl 12)]);
GotoXY(60,21);
Write('NONE :',YN[flags[Choix+1,2] and (1 shl 13) div (1 shl 13)]);
GotoXY(60,22);
Write('NONE :',YN[flags[Choix+1,2] and (1 shl 14) div (1 shl 14)]);
GotoXY(60,23);
Write('NONE :',YN[flags[Choix+1,2] and (1 shl 15) div (1 shl 15)]);
end;
gotoxy(40,24);
Write('use ctrl-insert/insert to copy/paste');
underline(44,54,24,$0f);
underline(56,62,24,$0f);

GotoXY(OldX,OldY);

MouseOn;
End;


Type ClipUnit = Record
    sight  :longint;  {1..9}
    HP     :Integer; {1..9999 > cannot display}
    Magician:Byte;   {0 = no; 1 = yes}
    BuildTime:byte;
    Gold   :byte;  {cost = this number * 10}
    Wood   :byte;
    Oil    :byte;
    UnitSize: Record
                 x,y:Integer;
                End;
    BoxSize:  Record
                 x,y:Integer;
                End;

    Range:   byte;
    Unknown2:byte;
    Unknown3:byte;
    Armor  : byte;
    Tag    : byte;  {0 = no;  1 = yes    building = no}
    Priority:byte;  {0 = high  255 = low}
    Basic  : byte;
    Piercing:byte;
    Up_weap: byte;  {0 = no;  1 = yes}
    Up_armor:byte;  {0 = no;  1 = yes}
    Projectile:byte;
    UnitType:byte;  {0 = land; 1 = air; 2 = water}
    Decay  : byte;  {0 = no decay; x = number of 6 sec. }
    Unknown4:byte;
    Movement:byte;  {1 = can move; 2 = peasant; 4 = sapper}
    Kill   : integer;
    Target : byte;  {1 = Land; 2 = Sea; 4 = Air}
    Flags  : Array[1..2] of Integer;
     End;

Var Choix,Old:Integer;
    I:Integer;
    done:Boolean;
    C:Char;
    Temp:ClipUnit;
    Full:Boolean;
    NoStat:Boolean;

begin
NoStat:=False;
clrscr;
MouseOff;
SetmousePos(8*28,1*8);
MouseOn;

full:=False;
done:=false;
Choix:=0;
Old:=0;
For I:=0 To 23 do Writeln(Bhex(I),'-',Name^[I],'          ');
GotoXY(1,1);

Redraw(Choix,Old);
StatScreen(Choix);
repeat
c:=#0;
Old := Choix;

If LeftButton = True Then
   Begin
   GetMouseEvent(0,Choix,Mapdata); {go into the unitdata section}
   C:=NoKey;
   End Else If Keypressed Then C:=Getkey;
          Case C of
          up:dec(choix);
          down:inc(choix);
          Chr(13):Done:=True;
          Chr(27):Done:=True;
          'a':IncrementB(mapdata.map_unitdata.armor[Choix+1],1,0,30);
          'A':DecrementB(mapdata.map_unitdata.armor[Choix+1],1,0,30);
          alt_a:IncrementB(mapdata.map_unitdata.armor[Choix+1],10,0,30);
          ctrl_A:DecrementB(mapdata.map_unitdata.armor[Choix+1],10,0,30);
          'b':IncrementB(mapdata.map_unitdata.Basic[Choix+1],1,0,255);
          'B':DecrementB(mapdata.map_unitdata.Basic[Choix+1],1,0,255);
          alt_b:IncrementB(mapdata.map_unitdata.Basic[Choix+1],10,0,255);
          ctrl_B:DecrementB(mapdata.map_unitdata.Basic[Choix+1],10,0,255);
          'c':ToggleB(mapdata.map_unitdata.Magician[Choix+1],0);
          'C':ToggleB(mapdata.map_unitdata.Magician[Choix+1],0);
          'd':IncrementB(mapdata.map_unitdata.Piercing[Choix+1],1,0,255);
          'D':DecrementB(mapdata.map_unitdata.Piercing[Choix+1],1,0,255);
          alt_d:IncrementB(mapdata.map_unitdata.Piercing[Choix+1],10,0,255);
          ctrl_D:DecrementB(mapdata.map_unitdata.Piercing[Choix+1],10,0,255);
          'e':ToggleB(mapdata.map_unitdata.Up_weap[choix+1],0);
          'E':ToggleB(mapdata.map_unitdata.Up_weap[Choix+1],0);

          'f':If Choix < 58 Then IncrementB(mapdata.map_unitdata.Movement[Choix+1],1,1,6);
          'F':If Choix < 58 Then DecrementB(mapdata.map_unitdata.Movement[Choix+1],1,1,6);

          'g':IncrementB(mapdata.map_unitdata.Gold[Choix+1],1,0,255);
          'G':DecrementB(mapdata.map_unitdata.Gold[Choix+1],1,0,255);
          alt_g:IncrementB(mapdata.map_unitdata.Gold[Choix+1],10,0,255);
          ctrl_G:DecrementB(mapdata.map_unitdata.Gold[Choix+1],10,0,255);
          'h':IncrementW(mapdata.map_unitdata.HP[Choix+1],10,0,32000);
          'H':DecrementW(mapdata.map_unitdata.HP[Choix+1],10,0,32000);
          alt_h:IncrementW(mapdata.map_unitdata.HP[Choix+1],100,0,32000);
          ctrl_H:DecrementW(mapdata.map_unitdata.HP[Choix+1],100,0,32000);
          'i':IncrementB(mapdata.map_unitdata.BuildTime[Choix+1],1,0,255);
          'I':DecrementB(mapdata.map_unitdata.BuildTime[Choix+1],1,0,255);
          alt_i:IncrementB(mapdata.map_unitdata.BuildTime[Choix+1],10,0,255);
          ctrl_I:DecrementB(mapdata.map_unitdata.BuildTime[Choix+1],10,0,255);
          'j':IncrementB(mapdata.map_unitdata.ReactRange[Choix+1],1,0,255);
          'J':DecrementB(mapdata.map_unitdata.ReactRange[Choix+1],1,0,255);
          alt_j:IncrementB(mapdata.map_unitdata.ReactRange[Choix+1],10,0,255);
          ctrl_j:DecrementB(mapdata.map_unitdata.ReactRange[Choix+1],10,0,255);
          'k':ToggleB(mapdata.map_unitdata.Target[choix+1],2);
          'K':ToggleB(mapdata.map_unitdata.Target[Choix+1],2);
          'l':ToggleB(mapdata.map_unitdata.Target[choix+1],0);
          'L':ToggleB(mapdata.map_unitdata.Target[Choix+1],0);
          'm':IncrementB(mapdata.map_unitdata.Projectile[Choix+1],1,0,50);
          'M':DecrementB(mapdata.map_unitdata.Projectile[Choix+1],1,0,50);
          'n':ToggleB(mapdata.map_unitdata.tag[choix+1],0);
          'N':ToggleB(mapdata.map_unitdata.tag[Choix+1],0);
          'o':IncrementB(mapdata.map_unitdata.Oil[Choix+1],1,0,255);
          'O':DecrementB(mapdata.map_unitdata.Oil[Choix+1],1,0,255);
          alt_o:IncrementB(mapdata.map_unitdata.Oil[Choix+1],10,0,255);
          ctrl_o:DecrementB(mapdata.map_unitdata.Oil[Choix+1],10,0,255);
          'p':IncrementB(mapdata.map_unitdata.Priority[Choix+1],1,0,255);
          'P':DecrementB(mapdata.map_unitdata.Priority[Choix+1],1,0,255);
          alt_p:IncrementB(mapdata.map_unitdata.Priority[Choix+1],10,0,255);
          ctrl_p:DecrementB(mapdata.map_unitdata.Priority[Choix+1],10,0,255);
          'q':IncrementB(mapdata.map_unitdata.AnnoyCPU[Choix+1],1,0,255);
          'Q':DecrementB(mapdata.map_unitdata.AnnoyCPU[Choix+1],1,0,255);
          alt_q:IncrementB(mapdata.map_unitdata.AnnoyCPU[Choix+1],10,0,255);
          ctrl_q:DecrementB(mapdata.map_unitdata.AnnoyCPU[Choix+1],10,0,255);
          'r':IncrementB(mapdata.map_unitdata.Range[Choix+1],1,0,255);
          'R':DecrementB(mapdata.map_unitdata.Range[Choix+1],1,0,255);
          alt_r:IncrementB(mapdata.map_unitdata.Range[Choix+1],10,0,255);
          ctrl_R:DecrementB(mapdata.map_unitdata.Range[Choix+1],10,0,255);
          's':IncrementD(mapdata.map_unitdata.Sight[Choix+1],1,1,9);
          'S':DecrementD(mapdata.map_unitdata.Sight[Choix+1],1,1,9);
          't':IncrementB(mapdata.map_unitdata.UnitType[Choix+1],1,0,2);
          'T':DecrementB(mapdata.map_unitdata.UnitType[Choix+1],1,0,2);
          'u':ToggleB(mapdata.map_unitdata.Up_armor[choix+1],0);
          'U':ToggleB(mapdata.map_unitdata.Up_armor[Choix+1],0);
          'v':IncrementW(mapdata.map_unitdata.Kill[Choix+1],10,0,10000);
          'V':DecrementW(mapdata.map_unitdata.Kill[Choix+1],10,0,10000);
          alt_v:IncrementW(mapdata.map_unitdata.Kill[Choix+1],100,0,10000);
          ctrl_v:DecrementW(mapdata.map_unitdata.Kill[Choix+1],100,0,10000);
          'w':IncrementB(mapdata.map_unitdata.Wood[Choix+1],1,0,255);
          'W':DecrementB(mapdata.map_unitdata.Wood[Choix+1],1,0,255);
          alt_w:IncrementB(mapdata.map_unitdata.Wood[Choix+1],10,0,255);
          ctrl_W:DecrementB(mapdata.map_unitdata.Wood[Choix+1],10,0,255);
          'x':IncrementB(mapdata.map_unitdata.PlayerReact[Choix+1],1,0,255);
          'X':DecrementB(mapdata.map_unitdata.PlayerReact[Choix+1],1,0,255);
          alt_x:IncrementB(mapdata.map_unitdata.PlayerReact[Choix+1],10,0,255);
          ctrl_x:DecrementB(mapdata.map_unitdata.PlayerReact[Choix+1],10,0,255);
          'y':IncrementB(mapdata.map_unitdata.Decay[Choix+1],1,0,255);
          'Y':DecrementB(mapdata.map_unitdata.Decay[Choix+1],1,0,255);
          alt_y:IncrementB(mapdata.map_unitdata.Decay[Choix+1],10,0,255);
          ctrl_Y:DecrementB(mapdata.map_unitdata.Decay[Choix+1],10,0,255);
          'Z':ToggleB(mapdata.map_unitdata.Target[choix+1],1);
          'z':ToggleB(mapdata.map_unitdata.Target[Choix+1],1);
          '-':IncrementW(mapdata.map_unitdata.UnitSize[Choix+1].X,1,1,120);
          '_':DecrementW(mapdata.map_unitdata.UnitSize[Choix+1].X,1,1,120);
          '=':IncrementW(mapdata.map_unitdata.UnitSize[Choix+1].Y,1,1,120);
          '+':DecrementW(mapdata.map_unitdata.UnitSize[Choix+1].Y,1,1,120);
          '9':IncrementW(mapdata.map_unitdata.BoxSize[Choix+1].X,1,1,250);
          '(':DecrementW(mapdata.map_unitdata.BoxSize[Choix+1].X,1,1,250);
          '0':IncrementW(mapdata.map_unitdata.BoxSize[Choix+1].Y,1,1,250);
          ')':DecrementW(mapdata.map_unitdata.BoxSize[Choix+1].Y,1,1,250);
          f10:IncrementW(mapdata.map_unitdata.Frame[Choix+1],1,0,32000);
          Shift_f10:DecrementW(mapdata.map_unitdata.Frame[Choix+1],1,0,32000);
          alt_f10:IncrementW(mapdata.map_unitdata.Frame[Choix+1],10,0,32000);
          ctrl_f10:DecrementW(mapdata.map_unitdata.Frame[Choix+1],10,0,32000);
          '1':ToggleD(mapdata.map_unitdata.flags[Choix+1,1],0);
          '2':ToggleD(mapdata.map_unitdata.flags[Choix+1,1],1);
          '3':ToggleD(mapdata.map_unitdata.flags[Choix+1,1],2);
          '4':ToggleD(mapdata.map_unitdata.flags[Choix+1,1],3);
          '5':ToggleD(mapdata.map_unitdata.flags[Choix+1,1],4);
          '6':ToggleD(mapdata.map_unitdata.flags[Choix+1,1],5);
          '7':ToggleD(mapdata.map_unitdata.flags[Choix+1,1],6);
          '8':ToggleD(mapdata.map_unitdata.flags[Choix+1,1],7);
          F1:ToggleD(mapdata.map_unitdata.flags[Choix+1,1],8);
          F2:ToggleD(mapdata.map_unitdata.flags[Choix+1,1],9);
          F3:ToggleD(mapdata.map_unitdata.flags[Choix+1,1],10);
          F4:ToggleD(mapdata.map_unitdata.flags[Choix+1,1],11);
          F5:ToggleD(mapdata.map_unitdata.flags[Choix+1,1],12);
          F6:ToggleD(mapdata.map_unitdata.flags[Choix+1,1],13);
          F7:ToggleD(mapdata.map_unitdata.flags[Choix+1,1],14);
          F8:ToggleD(mapdata.map_unitdata.flags[Choix+1,1],15);
         Shift_F1:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],0);
         Shift_F2:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],1);
         Shift_F3:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],2);
         Shift_F4:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],3);
         Shift_F5:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],4);
         Shift_F6:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],5);
         Shift_F7:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],6);
         Shift_F8:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],7);
         alt_F1:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],8);
         alt_F2:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],9);
         alt_F3:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],10);
         alt_F4:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],11);
         alt_F5:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],12);
         alt_F6:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],13);
         alt_F7:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],14);
         alt_F8:ToggleD(mapdata.map_unitdata.flags[Choix+1,2],15);
         Del:RestoreUnit(Choix,mapdata);
         ctrl_ins:Begin
                  With mapdata.map_unitdata do
                   Begin
                   Temp.Sight:=Sight[Choix+1];
                   Temp.HP:=HP[Choix+1];
                   Temp.Magician:=Magician[Choix+1];
                   Temp.Buildtime:=BuildTime[Choix+1];
                   Temp.Gold:=Gold[Choix+1];
                   Temp.Wood:=Wood[Choix+1];
                   Temp.Oil:=Oil[Choix+1];
                   Temp.UnitSize.X:=UnitSize[Choix+1].X;
                   Temp.UnitSize.y:=UnitSize[Choix+1].y;
                   Temp.BoxSize.X:=BoxSize[Choix+1].X;
                   Temp.BoxSize.y:=BoxSize[Choix+1].y;
                   Temp.Range:=Range[Choix+1];
                   Temp.Unknown2:=ReactRange[Choix+1];
                   Temp.Unknown3:=PlayerReact[Choix+1];
                   Temp.Armor:=Armor[Choix+1];
                   Temp.Tag:=Tag[Choix+1];
                   Temp.Priority:=Priority[Choix+1];
                   Temp.Basic:=Basic[Choix+1];
                   Temp.Piercing:=Piercing[Choix+1];
                   Temp.Up_weap:=Up_Weap[Choix+1];
                   Temp.Up_armor:=Up_armor[Choix+1];
                   Temp.Projectile:=Projectile[Choix+1];
                   Temp.UnitType:=UnitType[Choix+1];
                   Temp.Decay:=Decay[Choix+1];
                   Temp.Unknown4:=AnnoyCPU[Choix+1];
                   If Choix+1 >= 58 Then Temp.Movement:=0 Else Temp.Movement:=Movement[Choix+1];
                   Temp.Kill:=Kill[Choix+1];
                   Temp.Target:=Target[Choix+1];
                   Temp.Flags[1]:=Flags[Choix+1,1];
                   Temp.Flags[2]:=Flags[Choix+1,2];
                   End;
                  Full:=True;
                  Sound(1000);
                  Delay(50);
                  Nosound;
                  End;
         ins:If Full Then
             Begin
                  With mapdata.map_unitdata do
                   Begin
                   Sight[Choix+1]:=Temp.Sight;
                   HP[Choix+1]:=Temp.HP;
                   Magician[Choix+1]:=Temp.Magician;
                   Buildtime[Choix+1]:=Temp.BuildTime;
                   Gold[Choix+1]:=Temp.Gold;
                   Wood[Choix+1]:=Temp.Wood;
                   Oil[Choix+1]:=Temp.Oil;
                   UnitSize[Choix+1].X:=Temp.UnitSize.X;
                   UnitSize[Choix+1].y:=Temp.UnitSize.y;
                   BoxSize[Choix+1].X:=Temp.BoxSize.X;
                   BoxSize[Choix+1].y:=Temp.BoxSize.y;
                   Range[Choix+1]:=Temp.Range;
                   ReactRange[Choix+1]:=Temp.Unknown2;
                   PlayerReact[Choix+1]:=Temp.Unknown3;
                   Armor[Choix+1]:=Temp.Armor;
                   Tag[Choix+1]:=Temp.Tag;
                   Priority[Choix+1]:=Temp.Priority;  {0 = high  255 = low}
                   Basic[Choix+1]:=Temp.Basic;
                   Piercing[Choix+1]:=Temp.Piercing;
                   Up_weap[Choix+1]:=Temp.Up_Weap;
                   Up_armor[Choix+1]:=Temp.Up_armor;
                   Projectile[Choix+1]:=Temp.Projectile;
                   UnitType[Choix+1]:=Temp.UnitType;
                   Decay[Choix+1]:=Temp.Decay;
                   AnnoyCPU[Choix+1]:=Temp.Unknown4;
                   If Choix+1 < 58 Then Movement[Choix+1]:=Temp.Movement;
                   Kill[Choix+1]:=Temp.Kill;
                   Target[Choix+1]:=Temp.Target;
                   Flags[Choix+1,1]:=Temp.Flags[1];
                   Flags[Choix+1,2]:=Temp.Flags[2];
                   End;
                  Sound(100);
                  Delay(50);
                  Nosound;
             End;
             Else NoStat:=True;
          END (*CASE*);
If Choix < 0 Then Choix:=0;
If Choix > Maxunit-1 Then Choix:=Maxunit-1;
If (Old <> Choix) Then Redraw(Choix,Old);
If C <> #0 then NoStat:=False;
IF NoStat = False Then StatScreen(Choix);

until done;
end;
{****************************************************************************}

{********************************  UPGRADES   *******************************}

Procedure EditUpgrade(Var Mapdata:Tmapdata);
    Procedure Redraw(Var Choix,Old:Integer);
    Var I:byte;
        Diff:Integer;
        X,Y:Integer;
    Begin
   MouseOFF;
    UnderLine(1,25,WhereY,7);
    Y:=WhereY;
    Diff:=Abs(Choix-Old);
    If Choix > MaxUpgrade-1 Then Choix := MaxUpgrade-1;
    If Choix < 0 Then Choix := 0;
    If Choix < Old Then Y:=(Y-Diff) Else If Choix > Old Then Y:=(Y+Diff);
       If (Y = 0) {and (Choix-1<>0)} Then
       Begin
       Scroll(1,Diff,0,23,0,25,$7);
       Y:=1;
       GotoXY(1,Y);
       Write(Bhex(Choix),'-',Uname^[Choix],'          ');
       End;
   If Y = 25 Then
   Begin
   Scroll(-1,Diff,0,23,0,25,$7);
   Y:=24;
   GotoXY(1,Y);
   Write(Bhex(Choix),'-',Uname^[Choix],'          ');
   End;
   Underline(1,25,Y,$4f);
   GotoXY(1,Y);
   MouseON;
   end;


Procedure StatScreen(Var Choix:Integer);
Var OldX,OldY:Integer;
Begin
MouseOFF;

OldX:=WhereX; OldY:=WhereY;
gotoxy(40,2);
write(Uname^[Choix],'                  ');
gotoxy(45,5);
write('Upgrade time: ',mapdata.map_upgrade.time[choix+1]:5);
underline(45,45,5,$0f);
gotoxy(45,6);
write('Gold Cost   : ',mapdata.map_upgrade.gold[choix+1]:5);
underline(45,45,6,$0f);
gotoxy(45,7);
write('Lumber Cost : ',mapdata.map_upgrade.wood[choix+1]:5);
underline(45,45,7,$0f);
gotoxy(45,8);
write('Oil Cost    : ',mapdata.map_upgrade.oil[choix+1]:5);
underline(45,45,8,$0f);
gotoxy(45,9);
write('Icon used   : ',mapdata.map_upgrade.icon[choix+1]:5);
underline(45,45,9,$0f);
gotoxy(45,10);
write('Group       : ',mapdata.map_upgrade.group[choix+1]:5);
underline(46,46,10,$0f);

gotoxy(45,12);
write('Bit affect  : ',mapdata.map_upgrade.Affect[choix+1]:10);
gotoxy(45,13);
write(DecBin(mapdata.map_upgrade.Affect[choix+1]));
gotoxy(40,14);
Write('keys for the `bit flags'' field: ');
gotoxy(44,15);
Write('*use <- or -> to shift bit');
gotoxy(44,16);
Write('*use 0 to set number value at 0');
gotoxy(44,17);
Write('*use - to set number value at 1');
gotoxy(44,18);
Write('*use + to set number all 32 bit');
underline(49,50,15,$0f);
underline(55,56,15,$0f);
underline(49,49,16,$0f);
underline(49,49,17,$0f);
underline(49,49,18,$0f);
gotoxy(44,18);
Write('*alter with [1..8]  or  [F1..F8]');
gotoxy(45,19);
Write('    [ShiftF1..F8]  or  [AltF1..F8]');
underline(57,57,18,$0f);
underline(60,60,18,$0f);
underline(69,70,18,$0f);
underline(73,74,18,$0f);

underline(50,56,19,$0f);
underline(59,60,19,$0f);
underline(69,73,19,$0f);
underline(76,77,19,$0f);

gotoxy(40,22);
Write('use ctrl-insert/insert to copy/paste');
underline(44,54,22,$0f);
underline(56,62,22,$0f);

gotoxy(oldx,oldy);
MouseON;
end;

Type ClipUpgrade = Record
    Time   :byte;
    Gold   :Integer;
    Wood   :Integer;
    Oil    :Integer;
    Icon   :Integer;
    Group  :Integer;
    Unknown:Longint;
     End;


Var Choix,Old:Integer;
    I:Integer;
    done:Boolean;
    C:Char;
    Temp:ClipUpgrade;
    Full:Boolean;
    NoStat:Boolean;
Begin
MouseOFF;

nostat:=False;
done:=false;
Full:=False;
Choix:=0;
Old:=0;
Clrscr;
For I:=0 To 23 do Writeln(Bhex(I),'-',UName^[I],'          ');
SetmousePos(8*30,1*8);
MouseON;

GotoXY(1,1);
NoStat:=False;
Redraw(Choix,Old);
StatScreen(Choix);

repeat
c:=#0;
{Redraw(Choix,Old);
StatScreen(Choix);}
Old := Choix;
    If LeftButton Then
    Begin
    GetMouseEvent(1,Choix,mapdata);
    c:=Nokey;
    NoStat:=false;
    End
    Else If Keypressed then C:=Getkey;
          Case C of
          up:dec(choix);
          down:inc(choix);
          Chr(13):Done:=True;
          Chr(27):Done:=True;
          'g':IncrementW(mapdata.map_upgrade.Gold[Choix+1],10,0,32000);
          'G':DecrementW(mapdata.map_upgrade.Gold[Choix+1],10,0,32000);
          alt_g:IncrementW(mapdata.map_upgrade.Gold[Choix+1],100,0,32000);
          ctrl_g:DecrementW(mapdata.map_upgrade.Gold[Choix+1],100,0,32000);
          'i':IncrementW(mapdata.map_upgrade.Icon[Choix+1],1,0,32000);
          'I':DecrementW(mapdata.map_upgrade.Icon[Choix+1],1,0,32000);
          alt_i:IncrementW(mapdata.map_upgrade.Icon[Choix+1],10,0,32000);
          ctrl_i:DecrementW(mapdata.map_upgrade.Icon[Choix+1],10,0,32000);
          'l':IncrementW(mapdata.map_upgrade.Wood[Choix+1],10,0,32000);
          'L':DecrementW(mapdata.map_upgrade.Wood[Choix+1],10,0,32000);
          alt_L:IncrementW(mapdata.map_upgrade.Wood[Choix+1],100,0,32000);
          ctrl_L:DecrementW(mapdata.map_upgrade.Wood[Choix+1],100,0,32000);
          'o':IncrementW(mapdata.map_upgrade.Oil[Choix+1],10,0,32000);
          'O':DecrementW(mapdata.map_upgrade.Oil[Choix+1],10,0,32000);
          alt_o:IncrementW(mapdata.map_upgrade.Oil[Choix+1],100,0,32000);
          ctrl_o:DecrementW(mapdata.map_upgrade.Oil[Choix+1],100,0,32000);
          'r':IncrementW(mapdata.map_upgrade.Group[Choix+1],1,0,32000);
          'R':DecrementW(mapdata.map_upgrade.Group[Choix+1],1,0,32000);
          alt_r:IncrementW(mapdata.map_upgrade.Group[Choix+1],10,0,32000);
          ctrl_r:DecrementW(mapdata.map_upgrade.Group[Choix+1],10,0,32000);
          'u':IncrementB(mapdata.map_upgrade.Time[Choix+1],1,0,250);
          'U':DecrementB(mapdata.map_upgrade.Time[Choix+1],1,0,250);
          alt_u:IncrementB(mapdata.map_upgrade.Time[Choix+1],10,0,250);
          ctrl_u:DecrementB(mapdata.map_upgrade.Time[Choix+1],10,0,250);
          '0': mapdata.map_upgrade.Affect[Choix+1]:=0;
          '+','=': mapdata.map_upgrade.Affect[Choix+1]:=$7FFFFFFF;
          '-': mapdata.map_upgrade.Affect[Choix+1]:=1;
          '1': ToggleL(mapdata.map_upgrade.Affect[Choix+1],0);
          '2': ToggleL(mapdata.map_upgrade.Affect[Choix+1],1);
          '3': ToggleL(mapdata.map_upgrade.Affect[Choix+1],2);
          '4': ToggleL(mapdata.map_upgrade.Affect[Choix+1],3);
          '5': ToggleL(mapdata.map_upgrade.Affect[Choix+1],4);
          '6': ToggleL(mapdata.map_upgrade.Affect[Choix+1],5);
          '7': ToggleL(mapdata.map_upgrade.Affect[Choix+1],6);
          '8': ToggleL(mapdata.map_upgrade.Affect[Choix+1],7);
          F1: ToggleL(mapdata.map_upgrade.Affect[Choix+1],8);
          F2: ToggleL(mapdata.map_upgrade.Affect[Choix+1],9);
          F3: ToggleL(mapdata.map_upgrade.Affect[Choix+1],10);
          F4: ToggleL(mapdata.map_upgrade.Affect[Choix+1],11);
          F5: ToggleL(mapdata.map_upgrade.Affect[Choix+1],12);
          F6: ToggleL(mapdata.map_upgrade.Affect[Choix+1],13);
          F7: ToggleL(mapdata.map_upgrade.Affect[Choix+1],14);
          F8: ToggleL(mapdata.map_upgrade.Affect[Choix+1],15);
          Shift_F1: ToggleL(mapdata.map_upgrade.Affect[Choix+1],16);
          Shift_F2: ToggleL(mapdata.map_upgrade.Affect[Choix+1],17);
          Shift_F3: ToggleL(mapdata.map_upgrade.Affect[Choix+1],18);
          Shift_F4: ToggleL(mapdata.map_upgrade.Affect[Choix+1],19);
          Shift_F5: ToggleL(mapdata.map_upgrade.Affect[Choix+1],20);
          Shift_F6: ToggleL(mapdata.map_upgrade.Affect[Choix+1],21);
          Shift_F7: ToggleL(mapdata.map_upgrade.Affect[Choix+1],22);
          Shift_F8: ToggleL(mapdata.map_upgrade.Affect[Choix+1],23);
          Alt_F1: ToggleL(mapdata.map_upgrade.Affect[Choix+1],24);
          Alt_F2: ToggleL(mapdata.map_upgrade.Affect[Choix+1],25);
          Alt_F3: ToggleL(mapdata.map_upgrade.Affect[Choix+1],26);
          Alt_F4: ToggleL(mapdata.map_upgrade.Affect[Choix+1],27);
          Alt_F5: ToggleL(mapdata.map_upgrade.Affect[Choix+1],28);
          Alt_F6: ToggleL(mapdata.map_upgrade.Affect[Choix+1],29);
          Alt_F7: ToggleL(mapdata.map_upgrade.Affect[Choix+1],30);
          Alt_F8: ToggleL(mapdata.map_upgrade.Affect[Choix+1],31);
          Del:RestoreUpgrade(Choix,mapdata);
          ctrl_ins:Begin
                   With Mapdata.map_upgrade Do
                        Begin
                        Temp.Time:=Time[Choix+1];
                        Temp.Gold:=Gold[Choix+1];
                        Temp.Wood:=Wood[Choix+1];
                        Temp.Oil:=Oil[Choix+1];
                        Temp.Icon:=Icon[Choix+1];
                        Temp.Group:=Group[Choix+1];
                        Temp.Unknown:=Affect[Choix+1];
                        Full:=True;
                        Sound(1000);
                        Delay(50);
                        Nosound;
                        End;
                   End;
          INS: If Full Then
               Begin
                   With Mapdata.map_upgrade Do
                        Begin
                        Time[Choix+1]:=Temp.Time;
                        Gold[Choix+1]:=Temp.Gold;
                        Wood[Choix+1]:=Temp.Wood;
                        Oil[Choix+1]:=Temp.Oil;
                        Icon[Choix+1]:=Temp.Icon;
                        Group[Choix+1]:=Temp.Group;
                        Affect[Choix+1]:=Temp.Unknown;
                        End;
                  Sound(100);
                  Delay(50);
                  Nosound;
               End;
          Left: Begin
                If mapdata.map_upgrade.Affect[Choix+1] < 1048576 Then
                      mapdata.map_upgrade.Affect[Choix+1]:=mapdata.map_upgrade.Affect[Choix+1] shl 1;
                End;
          Right:Begin
                if mapdata.map_upgrade.Affect[Choix+1] <> 1 Then
                      mapdata.map_upgrade.Affect[Choix+1]:=mapdata.map_upgrade.Affect[Choix+1] shr 1;
                End;
          Else NoStat:=True;
          End(*CASE*);
If Choix < 0 Then Choix:=0;
If Choix > Maxupgrade-1 Then Choix:=Maxupgrade-1;
If (Old <> Choix) Then Redraw(Choix,Old);
If C <> #0 then NoStat:=False;
IF NoStat = False Then StatScreen(Choix);

until done;
end;



{**********************************  PLAYERS  *******************************}
Procedure EditPlayer(Var Mapdata:Tmapdata);
Procedure Menu(Var PlayerSelected:Integer);
Var OldX,OldY:Integer;
Begin
MouseOFF;
OldY:=WhereX;OldY:=WhereY;

GotoXY(35,1);
Writeln('Player properties');
GotoXY(1,5);
Write('Player color   : ',PlayerSelected,' : ',ColorName[PlayerSelected],'           ');
GotoXY(1,6);
Write('Player race    : ',RaceName[mapdata.map_side.Players[PlayerSelected]],'              ');
GotoXY(1,7);
Write('Player owner   : ',OwnerName[mapdata.map_owner.slot[PlayerSelected]],'                ');
GotoXY(1,8);
Write('Computer AI    : ',AIName[Mapdata.map_ai.Players[PlayerSelected]],'               ');
GotoXY(1,9);
Write('Starting Gold  : ',mapdata.map_start.gold.players[PlayerSelected]:5,'          ');
GotoXY(1,10);
Write('Starting Lumber: ',mapdata.map_start.Wood.players[PlayerSelected]:5,'          ');
GotoXY(1,11);
Write('Starting Oil   : ',mapdata.map_start.Oil.players[PlayerSelected]:5,'          ');

GotoXY(OldX,OldY);
MouseON;
End;


Procedure SelectAI(Var AI:Byte);
    Procedure Redraw(Var Choix,Old:Integer);
    Var I:byte;
        Diff:Integer;
        X,Y:Integer;
    Begin
    UnderLine(1,25,WhereY,7);
    Y:=WhereY;
    Diff:=Abs(Choix-Old);
    If Choix > MaxAI-1 Then Choix := MaxAI-1;
    If Choix < 0 Then Choix := 0;
    If Choix < Old Then Y:=(Y-Diff) Else If Choix > Old Then Y:=(Y+Diff);
       If (Y = 0) {and (Choix-1<>0)} Then
       Begin
       Scroll(1,Diff,0,23,0,25,$7);
       Y:=1;
       GotoXY(1,Y);
       Write(Bhex(Choix),'-',AiName[Choix],'          ');
       End;
   If Y = 25 Then
   Begin
   Scroll(-1,Diff,0,23,0,25,$7);
   Y:=24;
   GotoXY(1,Y);
   Write(Bhex(Choix),'-',AiName[Choix],'          ');
   End;
   Underline(1,25,Y,$4f);
   GotoXY(1,Y);
   end;

Var Choix,OldChoix:Integer;
    Done:Boolean;
    I:Integer;
    C:Char;
Begin
MouseOFF;
Clrscr;
GotoXY(1,1);
Done:=False;
Choix:=0;
OldChoix:=0;
For I:=0 To 23 do Writeln(Bhex(I),'-',AIName[I],'          ');
GotoXY(1,1);

Repeat
Redraw(Choix,OldChoix);
OldChoix:= Choix;
C:=Getkey;
          Case C of
          up:dec(choix);
          down:inc(choix);
          Chr(13):Begin
                  Done:=True;
                  Ai:=Choix;
                  End;
          Chr(27):Done:=True;
          END(*CASE*);
Until Done;
MouseON;
end;

Var PlayerSelected:Integer;
    C:Char;
    Done:Boolean;
    OldChoix,Choix:Integer;
    NoStat:Boolean;

Begin
MouseOFF;
Choix:=1;
OldChoix:=0;
Done:=False;
Clrscr;
PlayerSelected:=1;
MouseON;
NoStat:=False;
Repeat
C:=#0;
If NoStat = False Then Menu(PlayerSelected);
Underline(1,16,OldChoix+4,7);
Underline(1,16,Choix+4,$1a);
If LeftButton Then
   Begin
   GetMouseEvent(2,PlayerSelected,Mapdata);
   C:=Nokey;
   End
   Else if Keypressed Then C:=GetKey;
          Case C of
          Up:If Choix > 1 Then
             Begin
             OldChoix:=Choix;
             Dec(Choix);
             End;
          Down:If Choix < 7 Then
               Begin
               OldChoix:=Choix;
               Inc(Choix);
               End;

          Chr(13): Case Choix of
                   1:Begin
                     Inc(PlayerSelected);
                     If PlayerSelected > 8 Then PlayerSelected := 1;
                     End;
                   2:Begin
                     Inc(mapdata.map_side.players[PlayerSelected]);
                     If mapdata.map_side.players[PlayerSelected] > 2 Then mapdata.map_side.players[PlayerSelected] := 00;
                     End;
                   3:Begin
                     Inc(mapdata.map_owner.slot[PlayerSelected]);
                     If mapdata.map_owner.slot[PlayerSelected] > 7 Then mapdata.map_owner.slot[PlayerSelected] := 1;
                     End;
                   4:Begin
                          SelectAI(mapdata.map_ai.players[PlayerSelected]);
                          Clrscr;
                     End;
                   5:GetInteger(mapdata.map_start.gold.players[PlayerSelected],18,9,0,65000);
                   6:GetInteger(mapdata.map_start.wood.players[PlayerSelected],18,10,0,65000);
                   7:GetInteger(mapdata.map_start.oil.players[PlayerSelected],18,11,0,65000);
                   END(*CASE*);
          Right: Case Choix of
                   1:Begin
                     Inc(PlayerSelected);
                     If PlayerSelected > 8 Then PlayerSelected := 1;
                     End;
                   2:Begin
                     Inc(mapdata.map_side.players[PlayerSelected]);
                     If mapdata.map_side.players[PlayerSelected] > 2 Then mapdata.map_side.players[PlayerSelected] := 00;
                     End;
                   3:Begin
                     Inc(mapdata.map_owner.slot[PlayerSelected]);
                     If mapdata.map_owner.slot[PlayerSelected] > 7 Then mapdata.map_owner.slot[PlayerSelected] := 1;
                     End;
                   END(*CASE*);
          Left: Case Choix of
                   1:Begin
                     Dec(PlayerSelected);
                     If PlayerSelected < 1 Then PlayerSelected := 8;
                     End;
                   2:Begin
                     If mapdata.map_side.players[PlayerSelected] = 0 Then mapdata.map_side.players[PlayerSelected] := 2
                     Else Dec(mapdata.map_side.players[PlayerSelected]);
                     End;
                   3:Begin
                     Dec(mapdata.map_owner.slot[PlayerSelected]);
                     If mapdata.map_owner.slot[PlayerSelected] < 1 Then mapdata.map_owner.slot[PlayerSelected] := 7;
                     End;
                   END(*CASE*);
          Chr(27):Done:=True;
          Else NoStat:=True;
          END(*CASE*);
If C <> Chr(0) then Nostat:=False;
Until Done;

end;
{****************************************************************************}


Procedure AskFile(Var Filename:DosFileName);
Var C:Char;
    I:Integer;
    Done:Boolean;
Begin
{Filename:='';}
Write(Filename);
Done:=False;
I:=Length(Filename)+1;
Repeat
c:=getkey;
          case C of
          ' '..'z': Begin
                    If I < 60 Then Begin
                    Write(C);
                    Filename[I]:=C;
                    Inc(i);
                    End;
                    End;
          Chr(8)  : Begin
                    If I > 1 Then
                    Begin
                    gotoXY(wherex-1,Wherey);
                    write(' ');
                    gotoXY(wherex-1,Wherey);
                    Filename[I]:=Chr(00);
                    dec(i);
                    End;
                    End;
          Chr(13) : Done:=true;
          Chr(27) : Begin Done:=true; Filename:= ''; I:=1; End;
          END;
until Done;
Filename[0]:=Chr(I-1);

end;

Procedure ScanFiles(ext:String;A:Byte;Var Max:Integer);
Var I:Integer;
    Tmp:SearchRec;
    Fr:Integer;
Begin
  I:=Max;
  FindFirst(ext, a, Tmp);
  Dirinfo[Max]:=Tmp;
  while DosError = 0 do
  begin
    If I <= 300 Then Inc(I);
    FindNext(Tmp);
    DirInfo[i]:=Tmp;
  end;
  Max:=i-1;
  If DirInfo[1].name = '' Then
  Begin
  End;
{SORT }

For Fr:=1 to max do
    For I:=0 to Max Do If Dirinfo[Fr].Name < DirInfo[I].Name Then
    Begin
    Tmp:=Dirinfo[i];
    Dirinfo[i]:=Dirinfo[Fr];
    Dirinfo[fr]:=tmp;
    End;

End;

Procedure ChangeDir(Var Dir:PathStr);
Var Max:integer;
    Ext:String;
    I:Integer;
Begin
Max:=0;
ScanFiles('*.',Directory,max);

End;

Procedure AskFile2(Var Filename:DosFileName; Ext:String; M:Integer);
Procedure ScreenCode;
Var Rep:String;
    i:Integer;
Begin
TextColor(7);
GotoXY(40,5);
Write('Alt-D for Dos shell session.');
GotoXY(40,6);
Write('Up   /   Down to select file.');
GotoXY(40,7);
Write('PgUp / PgDown to Change file page.');
GotoXY(40,8);
Write('Home /    End to go to bottom/top.');
GotoXY(40,9);
Write('Space to change directory.');
Underline(40,44,9,$F);
Underline(40,44,5,$F);
Underline(40,44,6,$F);
Underline(46,52,6,$F);
Underline(40,44,7,$F);
Underline(46,52,7,$F);
Underline(40,44,8,$F);
Underline(46,52,8,$F);
GotoXY(40,15);
Write('Current directory:');
GetDir(0,Rep);
GotoXY(40,16);
Write(Rep);
For I:=1 to 30 - Length(Rep) Do Write(' ');
GotoXY(40,22);
Write('chdir? :');
TextColor(7);
End;

Var
    I:integer;
    Choix:Word;
    Max,Ndir:Integer;
    Done:Boolean;
    C:Char;
    Dir:Pathstr;
    Rep:String;
Begin
MouseOFF;
Done:=False;
Max:=0;
If M = 1 Then ScanFiles(ext,Directory,max)
   Else ScanFiles(ext,AnyFile,max);

Clrscr;
Choix:=0;
GotoXY(1,1);
For I:=(Choix div 24)*24 to (Choix div 24)*24 + 23 Do
    If I <= Max Then
       Begin
       Write(' ',DirInfo[I].Name:12,'     ',DirInfo[I].Size Div 1024:6,'kb');
       If Dirinfo[i].Attr And Directory <> 0 Then Writeln(' d ')
          else Writeln(' f ');
       End;

GotoXY(50,1);
Writeln(Choix+1:3,'/',Max+1:3);
GotoXY(1,(Choix mod 24)+1);
TextColor(15);
Write('>');
ScreenCode;

Repeat
C:=Getkey;
Case C of
Up: If Choix >= 1 Then Dec(Choix);
Down:Inc(Choix);
Pgdn:inc(Choix,24);
PgUp:If Choix > 24 Then Dec(Choix,24) Else Choix:=0;

Chr(32),Left,Right: Begin
IF M = 0 Then
Begin
Askfile2(FileName,'*.',1);
clrscr;
Max:=0;

Scanfiles('*.PUD',Anyfile,Max);

Choix:=0;
GotoXY(1,1);
For I:=(Choix div 24)*24 to (Choix div 24)*24 + 23 Do
    If I <= Max Then
       Begin
       Write(' ',DirInfo[I].Name:12,'     ',DirInfo[I].Size Div 1024:6,'kb');
       If Dirinfo[i].Attr And Directory <> 0 Then Writeln(' d ')
          else Writeln(' f ');
       End;

GotoXY(50,1);
Writeln(Choix+1:3,'/',Max+1:3);
GotoXY(1,(Choix mod 24)+1);
TextColor(15);
Write('>');
TextColor(7);
ScreenCode;

END;
      End;
Endkey:Choix:=Max;
Home:Choix:=0;
Esc:Begin
         Filename := '';
         Done:=true;
    End;
Alt_D,Alt_J:Begin
           Clrscr;
           CursorON;
           Writeln('War2unit Dos Shell Process ');
           Writeln('Type ''exit'' to return to war2unit.');
           Writeln;
           Underline(7,10,2,$F);
           {The following line will load any comspec }
           {now it will DOSSHELL under Windows NT if no comspec then
            it will attempt loading the default command.com}
           If GetEnv('COMSPEC') = '' then Exec('C:\COMMAND.COM','')
           Else Exec(GetEnv('COMSPEC'),'');
           Choix:=1;
           ScanFiles(ext,anyfile,max);
           Clrscr;
           CursorOFF;
      End;
Chr(13):Begin
        If (M = 1) and (dirinfo[choix].attr and Directory <> 0) Then Begin
           Chdir(dirinfo[choix].Name);
           Ndir:=0;
           If Ioresult = 0 Then
              Begin
              ScanFiles('*.',Directory,Ndir);
              Choix:=0;
              Done:=True;
              End;
        End Else Begin
            FileName:=Dirinfo[Choix].Name;
            Done:=True;
            End;
        End;


END(*CASE*);
If Choix < 0 Then Choix:=0;
If Choix > Max Then Choix:=Max;

GotoXY(1,1);
For I:=(Choix div 24)*24 to (Choix div 24)*24 + 23 Do
    If (I <= Max) Then Begin
        Write(' ',DirInfo[I].Name:12,'     ',DirInfo[I].Size Div 1024:6,'kb');
        If Dirinfo[i].Attr And Directory <> 0 Then Writeln(' d ')
            else Writeln(' f ');
        End
        Else WriteLn('                                                                       ');
GotoXY(50,1);
Writeln(Choix+1:3,'/',Max+1:3);
GotoXY(1,(Choix mod 24)+(Choix Div 24)+1);
If Choix >= 24 Then GotoXY(1,WhereY-1);
TextColor(15);
Write('>');
ScreenCode;

Until Done;

Clrscr;
End;

Procedure LoadPud(Var mapinfo:Tmapinfo; Var Mapdata:Tmapdata);
Var F:File;
    UnitSize:Longint;
    ERAX_Sig: String[4];
    warning:Integer;
Begin
if mapinfo.pud = '' then assign(F,'sim.pud') else assign(F,mapinfo.pud);
{$I-}
reset(f,1);
{$I+}
{load pud}
blockread(F,mapdata,Sizeof(Tmap_Type));
blockread(F,mapdata.map_version,Sizeof(Tmap_version));
blockread(F,mapdata.map_desc,Sizeof(Tmap_desc));
blockread(F,mapdata.map_owner,Sizeof(Tmap_owner));
blockread(F,mapdata.map_terrain,Sizeof(Tmap_terrain));

ERAX_SIG[0]:=Chr(4);
blockread(F,ERAX_SIG[1],4);
seek(F,filepos(F)-4);
if ERAX_SIG = 'ERAX' then
Begin
blockread(F,mapdata.map_terrainX,Sizeof(Tmap_terrainX));
Ver133:=True;
FileVer133:=True;
End Else Begin
    Ver133:=False;
    FileVer133:=False;
   end;

blockread(F,mapdata.map_dim,Sizeof(Tmap_dim));
blockread(F,mapdata.map_unitdata,8);
UnitSize:=mapdata.map_unitdata.l;
Seek(F,Filepos(F)-8);
blockread(F,mapdata.map_unitdata,UnitSize+8);
blockread(F,mapdata.map_upgrade,SizeOf(Tmap_upgrade));

blockread(F,mapdata.map_side,sizeof(Tmap_side));
blockread(F,mapdata.map_start,sizeof(Tmap_start));
blockread(F,mapdata.map_ai,sizeof(Tmap_ai));

{blockread(F,MapData,Sizeof(MapData));}


Close(f);
Warning:=0;
If (mapdata.map_unitdata.default = 1) or (mapdata.map_unitdata.hp[17] = 0) Then
   Begin
   mapdata.map_unitdata.default:=0;
   Writeln('*Warning* Unit data has to be added to this PUD.');
   Writeln('          Adding Expansion Default unit data.');
   Move(Pointer(@DefaultData)^,mapdata.map_unitdata.default,NormalSize{mapdata.map_unitdata.l});
   Inc(Warning);
   End;

If mapdata.map_upgrade.default = 1 Then
   Begin
   mapdata.map_upgrade.default:=0;
   Writeln('*Warning* Upgrade data has to be added to this PUD');
   Writeln('          Adding Default upgrade data.');
   Move(Pointer(Longint(@DefaultData)+NormalSize{mapdata.map_unitdata.l})^,mapdata.map_upgrade.default,mapdata.map_upgrade.l);
   Inc(Warning);
   End;

If Ver133 = True Then
   Begin
   Writeln('*Warning* Version required to play this map = v1.33');
   Inc(Warning);
   End;
   If Warning <> 0 Then
   Begin
   Writeln('[enter]');
   Readkey;
   End;
end;

Procedure SavePud(FileName:String; Var Mapdata:Tmapdata);
Var F:File;
Begin
   If Filename = '' then Filename := 'sim.pud';
   If Filename <> '' Then
   Begin
   assign(F,FileName);
   rewrite(f,1);
    seek(f,0);
{    blockwrite(F,MapData,sizeof(mapdata));}
    blockwrite(F,mapdata,Sizeof(Tmap_Type));
    blockwrite(F,mapdata.map_version,Sizeof(Tmap_version));
    blockwrite(F,mapdata.map_desc,Sizeof(Tmap_desc));
    blockwrite(F,mapdata.map_owner,Sizeof(Tmap_owner));
    blockwrite(F,mapdata.map_terrain,Sizeof(Tmap_terrain));
    if Ver133 = True Then Begin
    blockwrite(F,mapdata.map_terrainX,Sizeof(Tmap_terrainX));
    End;

    blockwrite(F,mapdata.map_dim,Sizeof(Tmap_dim));

    blockwrite(F,mapdata.map_unitdata,mapdata.map_unitdata.l+8);
    blockwrite(F,mapdata.map_upgrade,SizeOf(Tmap_upgrade));

    blockwrite(F,mapdata.map_side,sizeof(Tmap_side));
    blockwrite(F,mapdata.map_start,sizeof(Tmap_start));
    blockwrite(F,mapdata.map_ai,sizeof(Tmap_ai));
    close(f);
    End;
End;

procedure DrawScreen;
Begin
clrscr;
mouseOFF;
GotoXY(22,2);
Writeln('Warcraft ][ Unit modifier v',version[1],version[2],' INI v',version[4]);
gotoxy(30,8);
writeln('Map Info           ');
underline(30,30,8,$F);
gotoxy(30,9);
writeln('Edit Unit          ');
underline(30,30,9,$F);
gotoxy(30,10);
writeln('Edit Players       ');
underline(35,35,10,$F);
gotoxy(30,11);
writeln('Edit Upgrade       ');
underline(35,35,11,$F);
gotoxy(30,12);
Writeln('---------------------------');
gotoxy(30,13);
Writeln('Load unit file');
underline(30,30,13,$F);
gotoxy(30,14);
Writeln('Save unit file');
underline(30,30,14,$F);
gotoxy(30,15);
Writeln('Restore Default data');
underline(30,30,15,$F);
gotoxy(30,16);
Writeln('Exit and save changes');
underline(31,31,16,$F);
gotoxy(30,17);
writeln('Quit');
underline(30,30,17,$F);
gotoxy(30,18);
Writeln('---------------------------');
gotoxy(30,19);
writeln('Load another PUD');
gotoxy(30,20);
writeln('Save the current PUD');
mouseON;
end;


Procedure ExecuteChoix(Choix:Integer;Var Mapinfo:Tmapinfo; Var MapData:Tmapdata);
Var F,G,G2:File;
    F2:File of TMapdata;
    Filename:DosFileName;
    I:Integer;
    NR,NW:Word;
    Temp:Array[1..4096] of Byte;
Begin
Case Choix of
1: Begin
   ShowMapInfo(MapInfo,MapData);
   end;
2: Begin
   EditUnit(Mapdata);
   End;
3: EditPlayer(Mapdata);
4: EditUpgrade(Mapdata);

5:; {Null Line}

6:Begin
{  CursorON;
  Clrscr;
  GotoXY(30,1);
  Writeln('Loading unit file');
  GotoXY(1,5);
  Write('Enter the unit file to load : ');
  Filename:='';
  AskFile(FileName);}
  AskFile2(FileName,'*.UNT',0);
  CursorOFF;
  Assign(F,Filename);
 {$I-} Reset(F,1);{$I+}
 If(IOResult <> 0) or (Filename = '')Then
    Begin
      GotoXY(1,10);
      Sound(50);
      Writeln('Unit file not found!');
      Writeln('[press any key]');
      Delay(250);
      NoSound;
      CursorOFF;
      Readkey;
    End Else
    Begin
{     BlockRead(F,mapdata.map_unitdata.default,mapdata.map_unitdata.l);
      BlockRead(F,mapdata.map_upgrade.default,mapdata.map_upgrade.l);}
      BlockRead(F,mapdata.map_unitdata.default,NormalSize);
      BlockRead(F,mapdata.map_upgrade.default,mapdata.map_upgrade.l);
      If (mapdata.map_unitdata.l = ExpSize) And (FileSize(F) = ExpFileSize) Then
          BlockRead(F,mapdata.map_unitdata.tempbuff,sizeof(mapdata.map_unitdata.tempbuff));

{      BlockWrite(F,mapdata.map_unitdata.tempbuff,Sizeof(mapdata.map_unitdata.tempbuff));}
      Close(F);
      GotoXY(1,10);
      Writeln('Unit File loaded!');
      Sound(1000);
      Delay(500);
      Writeln('[press any key]');
      NoSound;
      Readkey;
    end;
  End;

7:Begin
  CursorON;
  Clrscr;
  GotoXY(30,1);
  Writeln('Saving unit file');
  GotoXY(1,5);
  Write('Enter the name of the unit file to save : ');
  filename:='UNIT00.UNT';
  Askfile(Filename);
  If Filename = '' Then
  Begin
  GotoXY(1,10);
  Writeln('Invalid file name, unit file not saved!');
  Writeln('[press any key]');
  Sound(50);
  Delay(250);
  Nosound;
  CursorOFF;
  Readkey;
  End Else
  Begin
  Assign(F,Filename);
  Rewrite(F,1);
{  BlockWrite(F,mapdata.map_unitdata.default,mapdata.map_unitdata.l);
  BlockWrite(F,mapdata.map_upgrade.default,mapdata.map_upgrade.l);}
  BlockWrite(F,mapdata.map_unitdata.default,NormalSize);
  BlockWrite(F,mapdata.map_upgrade.default,mapdata.map_upgrade.l);
  BlockWrite(F,mapdata.map_unitdata.tempbuff,Sizeof(mapdata.map_unitdata.tempbuff));

  Close(F);
  GotoXY(1,10);
  Writeln('Unit file ',Filename,' saved.');
  Writeln('[press any key]');
  Sound(1000);
  Delay(250);
  Nosound;
  CursorOFF;
  Readkey;
  End;
  End;

8:Begin
       Move(Pointer(@DefaultData)^,mapdata.map_unitdata.default,mapdata.map_unitdata.l);
       Move(Pointer(Longint(@DefaultData)+mapdata.map_unitdata.l)^,mapdata.map_upgrade.default,mapdata.map_upgrade.l);
       GotoXY(30,23);
       TextColor(12);
       Writeln('Default unit data restored.');
       TextColor(7);
       Sound(1000);
       delay(250);
       Nosound;
       Sound(750);
       delay(250);
       Nosound;
       Delay(750);
  End;

9: Begin
    FileName:=Mapinfo.pud;
    SavePud(tempfile,mapdata);
    assign(F,tempfile);
    reset(f,1);
    assign(G,mapinfo.pud);
    reset(g,1);
    seek(f,Filesize(f));
    If mapdata.map_unitdata.l = Expsize Then Begin
    if (filever133 = true) then seek(g,sizeof(Tmapdata)) {built-in}
       else seek(g,sizeof(Tmapdata)-10);
    End Else Begin
    if (filever133 = true) then seek(g,sizeof(Tmapdata)-254)
       else seek(g,sizeof(Tmapdata)-10-254);
    End;

    Repeat
    BlockRead(G,Temp,4096,NR);
    BlockWrite(F,Temp,NR,NW);
    Until (NR <> NW) or (EOF(G));
    close(f);
    Close(g);

    If (Mapinfo.pud = Filename) Then
    Begin
    assign(f,mapinfo.pud);
    erase(F);
    assign(f,tempfile);
    Rename(F,Mapinfo.pud);
    End Else
    Begin
    assign(f,tempfile);
    Rename(F,FileName);
    End;

   CursorON;
   Dispose(Name);
   Dispose(UName);
   clrscr;
   Writeln;
   Writeln(mapinfo.pud,' saved.');
   Writeln;

   INIF_FlushOnExit := TRUE;
   WriteProfileString('war2unit', 'NILL', 'NILL', 'NILL');
   Halt(0);
   End;

10: Begin
  CursorON;
   clrscr;
   Writeln;
   Writeln(mapinfo.pud,' NOT saved.');
   Writeln;
   INIF_FlushOnExit := TRUE;
   WriteProfileString('war2unit', 'NILL', 'NILL', 'NILL');
   Halt(0);
   End;
11:; {Null Line}

12: Begin
{    CursorON;
    Clrscr;
    GotoXY(30,1);
    Writeln('Loading PUD file');
    GotoXY(1,5);
    Write('PUD to load : ');
    FileName:='';
    AskFile(FileName);}
    AskFile2(FileName,'*.PUD',0);
    Assign(F,Filename);
   {$I-} Reset(F,1);{$I+}
    If(IOResult <> 0) or (Filename = '')Then
    Begin
      GotoXY(1,10);
      Sound(50);
      Writeln('PUD not found!');
      Writeln('[press any key]');
      Delay(250);
      NoSound;
      Readkey;
    End Else
    Begin
    With Mapinfo do
     Begin
     Pud:=Filename;
     Size:=FileSize(F);
     end;
     LoadPud(mapinfo,mapdata);
     Writeln;
     Writeln(mapinfo.pud,' loaded.');
     Writeln('[press any key]');
     Readkey;
    End;

    CursorOFF;
    End;

13: Begin
    CursorON;
    Clrscr;
    GotoXY(30,1);
    Writeln('Saving PUD file');
    GotoXY(1,5);
    Write('PUD name : ');
    Filename:=mapinfo.pud;
    AskFile(FileName);
    if filename <> '' then
    Begin
    For I := 1 to Length(Filename) do Filename[I]:=Upcase(Filename[I]);
    For I := 1 to Length(Mapinfo.pud) do Mapinfo.pud[I]:=Upcase(Mapinfo.pud[I]);

    SavePud(tempfile,mapdata);
    assign(F,tempfile);
    reset(f,1);
    assign(G,mapinfo.pud);
    reset(g,1);
    seek(f,Filesize(f));

    If mapdata.map_unitdata.l = Expsize Then Begin
    if (filever133 = true) then seek(g,sizeof(Tmapdata)) {built-in}
       else seek(g,sizeof(Tmapdata)-10);
    End Else Begin
    if (filever133 = true) then seek(g,sizeof(Tmapdata)-254)
       else seek(g,sizeof(Tmapdata)-10-254);
    End;

    Repeat
    BlockRead(G,Temp,4096,NR);
    BlockWrite(F,Temp,NR,NW);
    Until (NR <> NW) or (EOF(G));
    close(f);
    Close(g);

    If (Mapinfo.pud = Filename) Then
    Begin
    assign(f,mapinfo.pud);
    erase(F);
    assign(f,tempfile);
    Rename(F,Mapinfo.pud);
    End Else
    Begin
    assign(f,tempfile);
    assign(g,filename);
    erase(g);
    Rename(F,FileName);
    End;
    mapinfo.pud:=Filename;
    GotoXY(1,10);
    Writeln(mapinfo.pud,' saved.');
    Sound(1000);
    delay(500);
    Nosound;
    CursorOFF;
    Writeln('[press any key]');
    Readkey;
    End Else
    Begin
    Writeln;
    Writeln('PUD not saved.');
    Sound(59);
    delay(500);
    Nosound;
    Writeln('[press any key]');
    Readkey;
    CursorOFF;
    End;
    End;

End;
Drawscreen;
End;


Procedure TitleScr;
Begin
Clrscr;
GotoXY(1,10);
Writeln('                   Warcraft 2 unit modifier v',version[1],version[2],' INI v',version[4]);
Writeln;
Writeln('                  Written by Simon Pelsser (scorpion@axess.com)');
Writeln('                                       ',version[3]);
Writeln;
Writeln('              PRESSANYKEYTOBEGIN        ');
GetKey;
End;



Procedure Main(var mapinfo:tmapinfo;var mapdata:tmapdata);
Var C:Char;
    OldChoix,Choix:Integer;
    Esc:Boolean;
    NoStat:Boolean;
Begin
   MouseOFF;
   MouseON;

Drawscreen;
Choix:=1;
Esc:=False;
NoStat:=False;
repeat
C:=#0;
If NoStat = False Then drawscreen;
If NoStat = False Then underline(30,56,Choix+7,$1a);
If NoStat = False Then MouseON;
oldchoix:=choix;

If LeftButton Then
   Begin
   MouseOFF;
   GetMouseEvent(3,Choix,mapdata);
   C:=NoKey;
   End
   Else If Keypressed Then c:=getkey;
case c of
chr(13):executechoix(choix,mapinfo,mapdata);
up,left:dec(choix);
down,right:inc(choix);
'1','I','i','M','m':Choix:=1;
'2','E','e':Choix:=2;
'3','P','p':Choix:=3;
'4','U','u':Choix:=4;
'6','L','l':Choix:=6;
'7','S','s':Choix:=7;
'8','R','r':Choix:=8;
'9','X','x':Choix:=9;
'0','Q','q':Choix:=10;
ALT_L,Ctrl_L:Choix:=12;
ALT_S,Ctrl_S:Choix:=13;
chr(27): If (Esc = True) and (Choix = 9) Then Executechoix(9,mapinfo,mapdata) Else Choix:=9;
else Nostat:=True;
end(*CASE*);

If  c <> Chr(0) Then Nostat:=False;
If C = Chr(27) Then Esc:=True Else Esc:=False;
if choix < 1 then choix := 1;
if choix > MaxChoix then choix := MaxChoix;

If NoStat = False Then underline(30,56,OldChoix+7,$07);
until c=chr(255);

end;



var MapInfo:Tmapinfo;
    Mapdata:TmapData;



    F:File;


Begin
If MouseDriverPresent = False Then
   Begin
   Writeln('*Warning* Mouse not present.');
   Readkey;
   End;

Ver133:=False;
FileVer133:=False;

New(Name);
New(UName);

GetIni(Name^,Uname^,Proj);

Extend_Keyboard;
CursorOFF;
if paramcount < 1 then AskFile2(mapinfo.pud,'*.PUD',0)
   else mapinfo.pud:=paramstr(1);
assign(F,mapinfo.pud);
{$I-}
reset(f,1);
{$I+}
If (Ioresult <> 0) or (mapinfo.pud = '') Then
   Begin
   Writeln('Unit Modifier v',version[1],version[2],'     ',version[3]);
   Writeln('Syntax: ');
   Writeln(Paramstr(0),' filename.pud ');
   Writeln;
   CursorON;
   INIF_FlushOnExit := TRUE;
   WriteProfileString('war2unit', 'NILL', 'NILL', 'NILL');
   Halt(0);
   End;


mapinfo.size:=FileSize(F);
Loadpud(mapinfo,mapdata);

TextColor(7);
TitleScr;

{Mouse}
InitMouse;
SetmousePos(1,1);
MouseOn;

CheckBreak:=False;
Main(mapinfo,mapdata);

INIF_FlushOnExit := TRUE;
WriteProfileString('war2unit', 'NILL', 'NILL', 'NILL');
CursorON;
   Dispose(Name);
   Dispose(UName);

end.